/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.leg;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.leg.LegCallTime;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.utils.time.DurationUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class UnknownPathLeg
implements Leg {
    private final Place from;
    private final Place to;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final int nTransfers;

    public UnknownPathLeg(Place from, Place to, ZonedDateTime startTime, ZonedDateTime endTime, int nTransfers) {
        this.from = from;
        this.to = to;
        this.startTime = startTime;
        this.endTime = endTime;
        this.nTransfers = nTransfers;
    }

    @Override
    public Place from() {
        return this.from;
    }

    @Override
    public Place to() {
        return this.to;
    }

    @Override
    public ZonedDateTime startTime() {
        return this.startTime;
    }

    @Override
    public ZonedDateTime endTime() {
        return this.endTime;
    }

    @Override
    public boolean isTransitLeg() {
        return false;
    }

    @Override
    public boolean hasSameMode(Leg other) {
        return false;
    }

    @Override
    public LegCallTime start() {
        return LegCallTime.ofStatic(this.startTime);
    }

    @Override
    public LegCallTime end() {
        return LegCallTime.ofStatic(this.endTime);
    }

    @Override
    public double distanceMeters() {
        return -1.0;
    }

    @Override
    @Nullable
    public LineString legGeometry() {
        return null;
    }

    @Override
    public Set<TransitAlert> listTransitAlerts() {
        return Set.of();
    }

    @Override
    @Nullable
    public Emission emissionPerPerson() {
        return null;
    }

    @Override
    @Nullable
    public Leg withEmissionPerPerson(Emission emissionPerPerson) {
        return null;
    }

    @Override
    public int generalizedCost() {
        return 0;
    }

    @Override
    public List<FareOffer> fareOffers() {
        return List.of();
    }

    public int getNumberOfTransfers() {
        return this.nTransfers;
    }

    public String description() {
        return "Unknown transit " + this.nTransfers + "tx " + DurationUtils.durationToStr((Duration)this.duration());
    }

    public String toString() {
        return ToStringBuilder.of(UnknownPathLeg.class).addObj("from", (Object)this.from).addObj("to", (Object)this.to).addTime("startTime", this.startTime).addTime("endTime", this.endTime).addNum("numOfTransfers", (Number)this.nTransfers).toString();
    }
}

