/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.leg;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.leg.ElevationProfile;
import org.opentripplanner.model.plan.leg.LegCallTime;
import org.opentripplanner.model.plan.leg.StreetLegBuilder;
import org.opentripplanner.model.plan.walkstep.WalkStep;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.street.model.note.StreetNote;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class StreetLeg
implements Leg {
    private final TraverseMode mode;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final double distanceMeters;
    private final Place from;
    private final Place to;
    private final int generalizedCost;
    private final LineString legGeometry;
    private final List<WalkStep> walkSteps;
    private final Set<StreetNote> streetNotes;
    private final ElevationProfile elevationProfile;
    private final Boolean walkingBike;
    private final Boolean rentedVehicle;
    private final String vehicleRentalNetwork;
    private final Float accessibilityScore;
    private final Emission emissionPerPerson;

    protected StreetLeg(StreetLegBuilder builder) {
        this.mode = Objects.requireNonNull(builder.getMode());
        this.startTime = builder.getStartTime();
        this.endTime = builder.getEndTime();
        this.distanceMeters = DoubleUtils.roundTo2Decimals((double)builder.getDistanceMeters());
        this.from = builder.getFrom();
        this.to = builder.getTo();
        this.generalizedCost = builder.getGeneralizedCost();
        this.elevationProfile = builder.getElevationProfile();
        this.legGeometry = builder.getGeometry();
        this.walkSteps = Objects.requireNonNull(builder.getWalkSteps());
        this.streetNotes = Set.copyOf(builder.getStreetNotes());
        this.walkingBike = builder.getWalkingBike();
        this.rentedVehicle = builder.getRentedVehicle();
        this.vehicleRentalNetwork = builder.getVehicleRentalNetwork();
        this.accessibilityScore = builder.getAccessibilityScore();
        this.emissionPerPerson = builder.emissionPerPerson();
    }

    public static StreetLegBuilder of() {
        return new StreetLegBuilder();
    }

    public StreetLegBuilder copyOf() {
        return new StreetLegBuilder(this);
    }

    @Override
    public boolean isTransitLeg() {
        return false;
    }

    @Override
    public boolean isWalkingLeg() {
        return this.mode == TraverseMode.WALK;
    }

    @Override
    public boolean isStreetLeg() {
        return true;
    }

    public TraverseMode getMode() {
        return this.mode;
    }

    @Override
    public ZonedDateTime startTime() {
        return this.startTime;
    }

    @Override
    public ZonedDateTime endTime() {
        return this.endTime;
    }

    @Override
    public double distanceMeters() {
        return this.distanceMeters;
    }

    @Override
    public Place from() {
        return this.from;
    }

    @Override
    public Place to() {
        return this.to;
    }

    @Override
    public LineString legGeometry() {
        return this.legGeometry;
    }

    @Override
    public ElevationProfile elevationProfile() {
        return this.elevationProfile;
    }

    @Override
    public List<WalkStep> listWalkSteps() {
        return this.walkSteps;
    }

    @Override
    public Set<StreetNote> listStreetNotes() {
        return this.streetNotes;
    }

    @Override
    public Set<TransitAlert> listTransitAlerts() {
        return Set.of();
    }

    @Override
    public Boolean walkingBike() {
        return this.walkingBike;
    }

    @Override
    @Nullable
    public Float accessibilityScore() {
        return this.accessibilityScore;
    }

    @Override
    public Boolean rentedVehicle() {
        return this.rentedVehicle;
    }

    @Override
    public String vehicleRentalNetwork() {
        return this.vehicleRentalNetwork;
    }

    @Override
    public int generalizedCost() {
        return this.generalizedCost;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSameMode(Leg other) {
        if (!(other instanceof StreetLeg)) return false;
        StreetLeg oSL = (StreetLeg)other;
        if (!this.mode.equals((Object)oSL.mode)) return false;
        return true;
    }

    @Override
    public LegCallTime start() {
        return LegCallTime.ofStatic(this.startTime);
    }

    @Override
    public LegCallTime end() {
        return LegCallTime.ofStatic(this.endTime);
    }

    @Override
    public Leg withTimeShift(Duration duration) {
        return this.copyOf().withStartTime(this.startTime.plus(duration)).withEndTime(this.endTime.plus(duration)).build();
    }

    @Override
    public List<FareOffer> fareOffers() {
        return List.of();
    }

    public StreetLeg withAccessibilityScore(float accessibilityScore) {
        return this.copyOf().withAccessibilityScore(Float.valueOf(accessibilityScore)).build();
    }

    @Override
    @Nullable
    public Emission emissionPerPerson() {
        return this.emissionPerPerson;
    }

    @Override
    @Nullable
    public Leg withEmissionPerPerson(Emission emissionPerPerson) {
        return this.copyOf().withEmissionPerPerson(emissionPerPerson).build();
    }

    public String toString() {
        return ToStringBuilder.of(StreetLeg.class).addObj("from", (Object)this.from).addObj("to", (Object)this.to).addTime("startTime", this.startTime).addTime("endTime", this.endTime).addEnum("mode", (Enum)this.mode).addNum("distance", (Number)this.distanceMeters, "m").addNum("cost", (Number)this.generalizedCost).addCol("streetNotes", this.streetNotes).addBool("walkingBike", this.walkingBike).addBool("rentedVehicle", this.rentedVehicle).addStr("bikeRentalNetwork", this.vehicleRentalNetwork).toString();
    }
}

