/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.leg;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.leg.LegCallTime;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.utils.time.ServiceDateUtils;

class StopArrivalMapper {
    private final ZoneId zoneId;
    private final LocalDate serviceDate;
    private final TripTimes tripTimes;

    public StopArrivalMapper(ZoneId zoneId, LocalDate serviceDate, TripTimes tripTimes) {
        this.zoneId = Objects.requireNonNull(zoneId);
        this.serviceDate = Objects.requireNonNull(serviceDate);
        this.tripTimes = Objects.requireNonNull(tripTimes);
    }

    StopArrival map(int i, StopLocation stop, boolean realTime) {
        ZonedDateTime arrivalTime = ServiceDateUtils.toZonedDateTime((LocalDate)this.serviceDate, (ZoneId)this.zoneId, (int)this.tripTimes.getArrivalTime(i));
        ZonedDateTime departureTime = ServiceDateUtils.toZonedDateTime((LocalDate)this.serviceDate, (ZoneId)this.zoneId, (int)this.tripTimes.getDepartureTime(i));
        LegCallTime arrival = LegCallTime.ofStatic(arrivalTime);
        LegCallTime departure = LegCallTime.ofStatic(departureTime);
        if (realTime) {
            arrival = LegCallTime.of(arrivalTime, this.tripTimes.getArrivalDelay(i));
            departure = LegCallTime.of(departureTime, this.tripTimes.getDepartureDelay(i));
        }
        return new StopArrival(Place.forStop(stop), arrival, departure, i, this.tripTimes.gtfsSequenceOfStopIndex(i));
    }
}

