/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.leg;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;

public class ScheduledTransitLegBuilder<B extends ScheduledTransitLegBuilder<B>> {
    private static final int POS_NOT_SET = -1;
    private TripTimes tripTimes;
    private TripPattern tripPattern;
    private int boardStopIndexInPattern = -1;
    private int alightStopIndexInPattern = -1;
    private ZonedDateTime startTime;
    private ZonedDateTime endTime;
    private LocalDate serviceDate;
    private ZoneId zoneId;
    private TripOnServiceDate tripOnServiceDate;
    private ConstrainedTransfer transferFromPreviousLeg;
    private ConstrainedTransfer transferToNextLeg;
    private int generalizedCost;
    private Set<TransitAlert> alerts = Set.of();
    private Double distanceMeters;
    private Float accessibilityScore;
    private Emission emissionPerPerson;
    private List<FareOffer> fareOffers = List.of();

    public ScheduledTransitLegBuilder() {
    }

    public ScheduledTransitLegBuilder(ScheduledTransitLeg original) {
        this.tripTimes = original.tripTimes();
        this.tripPattern = original.tripPattern();
        this.boardStopIndexInPattern = original.boardStopPosInPattern();
        this.alightStopIndexInPattern = original.alightStopPosInPattern();
        this.startTime = original.startTime();
        this.endTime = original.endTime();
        this.serviceDate = original.serviceDate();
        this.tripOnServiceDate = original.tripOnServiceDate();
        this.transferFromPreviousLeg = original.transferFromPrevLeg();
        this.transferToNextLeg = original.transferToNextLeg();
        this.generalizedCost = original.generalizedCost();
        this.zoneId = original.zoneId();
        this.alerts = original.listTransitAlerts();
        this.distanceMeters = original.distanceMeters();
        this.fareOffers = original.fareOffers();
        this.accessibilityScore = original.accessibilityScore();
        this.emissionPerPerson = original.emissionPerPerson();
    }

    public B withTripTimes(TripTimes tripTimes) {
        this.tripTimes = tripTimes;
        return this.instance();
    }

    public TripTimes tripTimes() {
        return this.tripTimes;
    }

    public B withTripPattern(TripPattern tripPattern) {
        this.tripPattern = tripPattern;
        return this.instance();
    }

    public TripPattern tripPattern() {
        return this.tripPattern;
    }

    public B withBoardStopIndexInPattern(int boardStopIndexInPattern) {
        this.boardStopIndexInPattern = boardStopIndexInPattern;
        return this.instance();
    }

    public int boardStopIndexInPattern() {
        return this.boardStopIndexInPattern;
    }

    public B withAlightStopIndexInPattern(int alightStopIndexInPattern) {
        this.alightStopIndexInPattern = alightStopIndexInPattern;
        return this.instance();
    }

    public int alightStopIndexInPattern() {
        return this.alightStopIndexInPattern;
    }

    public B withStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this.instance();
    }

    public ZonedDateTime startTime() {
        return this.startTime;
    }

    public B withEndTime(ZonedDateTime endTime) {
        this.endTime = endTime;
        return this.instance();
    }

    public ZonedDateTime endTime() {
        return this.endTime;
    }

    public B withServiceDate(LocalDate serviceDate) {
        this.serviceDate = serviceDate;
        return this.instance();
    }

    public LocalDate serviceDate() {
        return this.serviceDate;
    }

    public B withZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this.instance();
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public B withTripOnServiceDate(TripOnServiceDate tripOnServiceDate) {
        this.tripOnServiceDate = tripOnServiceDate;
        return this.instance();
    }

    public TripOnServiceDate tripOnServiceDate() {
        return this.tripOnServiceDate;
    }

    public B withTransferFromPreviousLeg(ConstrainedTransfer transferFromPreviousLeg) {
        this.transferFromPreviousLeg = transferFromPreviousLeg;
        return this.instance();
    }

    public ConstrainedTransfer transferFromPreviousLeg() {
        return this.transferFromPreviousLeg;
    }

    public B withTransferToNextLeg(ConstrainedTransfer transferToNextLeg) {
        this.transferToNextLeg = transferToNextLeg;
        return this.instance();
    }

    public ConstrainedTransfer transferToNextLeg() {
        return this.transferToNextLeg;
    }

    public B withGeneralizedCost(int generalizedCost) {
        this.generalizedCost = generalizedCost;
        return this.instance();
    }

    public int generalizedCost() {
        return this.generalizedCost;
    }

    public B withAccessibilityScore(Float accessibilityScore) {
        this.accessibilityScore = accessibilityScore;
        return this.instance();
    }

    public B withAlerts(Set<TransitAlert> alerts) {
        this.alerts = Objects.requireNonNull(alerts);
        return this.instance();
    }

    public Set<TransitAlert> alerts() {
        return this.alerts;
    }

    public B withDistanceMeters(double distance) {
        this.distanceMeters = distance;
        return this.instance();
    }

    public Double distanceMeters() {
        return this.distanceMeters;
    }

    public Float accessibilityScore() {
        return this.accessibilityScore;
    }

    public Emission emissionPerPerson() {
        return this.emissionPerPerson;
    }

    public B withEmissionPerPerson(Emission emissionPerPerson) {
        this.emissionPerPerson = emissionPerPerson;
        return this.instance();
    }

    public List<FareOffer> fareOffers() {
        return this.fareOffers;
    }

    public B withFareProducts(List<FareOffer> fareProducts) {
        this.fareOffers = Objects.requireNonNull(fareProducts);
        return this.instance();
    }

    public ScheduledTransitLeg build() {
        return new ScheduledTransitLeg(this);
    }

    final B instance() {
        return (B)this;
    }
}

