/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.leg;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.model.plan.leg.LegCallTime;
import org.opentripplanner.model.plan.leg.LegConstructionSupport;
import org.opentripplanner.model.plan.leg.ScheduledTransitLegBuilder;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.model.plan.leg.StopArrivalMapper;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.model.plan.legreference.ScheduledTransitLegReference;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.lang.IntUtils;
import org.opentripplanner.utils.time.ServiceDateUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class ScheduledTransitLeg
implements TransitLeg {
    private static final int ZERO = 0;
    private static final Comparator<FareOffer> FARE_OFFER_COMPARATOR = Comparator.comparing(o -> o.fareProduct().id().getId()).thenComparing(FareOffer::uniqueId);
    private final TripTimes tripTimes;
    private final TripPattern tripPattern;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final LineString legGeometry;
    private final Set<TransitAlert> transitAlerts;
    private final ConstrainedTransfer transferFromPrevLeg;
    private final ConstrainedTransfer transferToNextLeg;
    protected final int boardStopPosInPattern;
    protected final int alightStopPosInPattern;
    private final int generalizedCost;
    private final LocalDate serviceDate;
    private final ZoneId zoneId;
    private final TripOnServiceDate tripOnServiceDate;
    private final double distanceMeters;
    private final double directDistanceMeters;
    private final Float accessibilityScore;
    private final Emission emissionPerPerson;
    private final List<FareOffer> fareOffers;

    protected ScheduledTransitLeg(ScheduledTransitLegBuilder<?> builder) {
        this.tripTimes = builder.tripTimes();
        this.tripPattern = Objects.requireNonNull(builder.tripPattern());
        int maxStopPosInPatternLimit = this.tripPattern.numberOfStops() - 1;
        this.boardStopPosInPattern = IntUtils.requireInRange((int)builder.boardStopIndexInPattern(), (int)0, (int)maxStopPosInPatternLimit, (String)"boardStopPosInPattern");
        this.alightStopPosInPattern = IntUtils.requireInRange((int)builder.alightStopIndexInPattern(), (int)(this.boardStopPosInPattern + 1), (int)maxStopPosInPatternLimit, (String)"alightStopPosInPattern");
        this.startTime = Objects.requireNonNull(builder.startTime());
        this.endTime = Objects.requireNonNull(builder.endTime());
        this.serviceDate = Objects.requireNonNull(builder.serviceDate());
        this.zoneId = Objects.requireNonNull(builder.zoneId());
        this.tripOnServiceDate = builder.tripOnServiceDate();
        this.transferFromPrevLeg = builder.transferFromPreviousLeg();
        this.transferToNextLeg = builder.transferToNextLeg();
        this.generalizedCost = builder.generalizedCost();
        List<Coordinate> transitLegCoordinates = LegConstructionSupport.extractTransitLegCoordinates(this.tripPattern, this.boardStopPosInPattern, this.alightStopPosInPattern);
        this.legGeometry = GeometryUtils.makeLineString(transitLegCoordinates);
        this.distanceMeters = DoubleUtils.roundTo2Decimals((Double)Objects.requireNonNull(builder.distanceMeters(), "distanceMeters"));
        this.directDistanceMeters = GeometryUtils.sumDistances(List.of(transitLegCoordinates.getFirst(), transitLegCoordinates.getLast()));
        this.transitAlerts = Set.copyOf(builder.alerts());
        this.accessibilityScore = builder.accessibilityScore();
        this.emissionPerPerson = builder.emissionPerPerson();
        this.fareOffers = builder.fareOffers().stream().sorted(FARE_OFFER_COMPARATOR).toList();
    }

    public ScheduledTransitLegBuilder copyOf() {
        return new ScheduledTransitLegBuilder(this);
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public TripTimes tripTimes() {
        return this.tripTimes;
    }

    public TripPattern tripPattern() {
        return this.tripPattern;
    }

    public Instant serviceDateMidnight() {
        return ServiceDateUtils.asStartOfService((LocalDate)this.serviceDate, (ZoneId)this.zoneId).toInstant();
    }

    @Override
    public boolean isScheduledTransitLeg() {
        return true;
    }

    @Override
    public ScheduledTransitLeg asScheduledTransitLeg() {
        return this;
    }

    @Override
    public Boolean isInterlinedWithPreviousLeg() {
        if (this.transferFromPrevLeg == null) {
            return false;
        }
        return this.transferFromPrevLeg.getTransferConstraint().isStaySeated();
    }

    @Override
    public Agency agency() {
        return this.trip().getRoute().getAgency();
    }

    @Override
    @Nullable
    public Operator operator() {
        return this.trip().getOperator();
    }

    @Override
    public Route route() {
        return this.trip().getRoute();
    }

    @Override
    public Trip trip() {
        return this.tripTimes.getTrip();
    }

    @Override
    public Accessibility tripWheelchairAccessibility() {
        return this.tripTimes.getWheelchairAccessibility();
    }

    @Override
    public LegCallTime start() {
        if (this.isRealTimeUpdated()) {
            return LegCallTime.of(this.startTime, this.departureDelay());
        }
        return LegCallTime.ofStatic(this.startTime);
    }

    @Override
    public LegCallTime end() {
        if (this.isRealTimeUpdated()) {
            return LegCallTime.of(this.endTime, this.arrivalDelay());
        }
        return LegCallTime.ofStatic(this.endTime);
    }

    @Override
    public TransitMode mode() {
        return this.trip().getMode();
    }

    @Override
    public ZonedDateTime startTime() {
        return this.startTime;
    }

    @Override
    public ZonedDateTime endTime() {
        return this.endTime;
    }

    @Override
    public int departureDelay() {
        return this.tripTimes.isCancelledStop(this.boardStopPosInPattern) || this.tripTimes.isNoDataStop(this.boardStopPosInPattern) ? 0 : this.tripTimes.getDepartureDelay(this.boardStopPosInPattern);
    }

    @Override
    public int arrivalDelay() {
        return this.tripTimes.isCancelledStop(this.alightStopPosInPattern) || this.tripTimes.isNoDataStop(this.alightStopPosInPattern) ? 0 : this.tripTimes.getArrivalDelay(this.alightStopPosInPattern);
    }

    @Override
    public boolean isRealTimeUpdated() {
        return this.tripTimes.isRealTimeUpdated(this.boardStopPosInPattern) || this.tripTimes.isRealTimeUpdated(this.alightStopPosInPattern);
    }

    @Override
    public RealTimeState realTimeState() {
        return this.tripTimes.getRealTimeState();
    }

    @Override
    public double distanceMeters() {
        return this.distanceMeters;
    }

    public double directDistanceMeters() {
        return this.directDistanceMeters;
    }

    @Override
    public Integer routeType() {
        return this.trip().getRoute().getGtfsType();
    }

    @Override
    public I18NString headsign() {
        return this.tripTimes.getHeadsign(this.boardStopPosInPattern);
    }

    @Override
    public LocalDate serviceDate() {
        return this.serviceDate;
    }

    @Override
    @Nullable
    public TripOnServiceDate tripOnServiceDate() {
        return this.tripOnServiceDate;
    }

    @Override
    public Place from() {
        return Place.forStop(this.tripPattern.getStop(this.boardStopPosInPattern));
    }

    @Override
    public Place to() {
        return Place.forStop(this.tripPattern.getStop(this.alightStopPosInPattern));
    }

    @Override
    public List<StopArrival> listIntermediateStops() {
        ArrayList<StopArrival> visits = new ArrayList<StopArrival>();
        StopArrivalMapper mapper = new StopArrivalMapper(this.zoneId, this.serviceDate, this.tripTimes);
        for (int i = this.boardStopPosInPattern + 1; i < this.alightStopPosInPattern; ++i) {
            StopLocation stop = this.tripPattern.getStop(i);
            StopArrival visit = mapper.map(i, stop, this.isRealTimeUpdated());
            visits.add(visit);
        }
        return visits;
    }

    @Override
    public LineString legGeometry() {
        return this.legGeometry;
    }

    @Override
    public Set<TransitAlert> listTransitAlerts() {
        return this.transitAlerts;
    }

    @Override
    public ScheduledTransitLeg decorateWithAlerts(Set<TransitAlert> alerts) {
        return ((ScheduledTransitLegBuilder)this.copyOf().withAlerts(alerts)).build();
    }

    @Override
    public TransitLeg decorateWithFareOffers(List<FareOffer> fares) {
        return ((ScheduledTransitLegBuilder)this.copyOf().withFareProducts(fares)).build();
    }

    @Override
    @Nullable
    public PickDrop boardRule() {
        if (this.transferFromPrevLeg != null && this.transferFromPrevLeg.getTransferConstraint().isStaySeated()) {
            return null;
        }
        return this.tripPattern.getBoardType(this.boardStopPosInPattern);
    }

    @Override
    @Nullable
    public PickDrop alightRule() {
        if (this.transferToNextLeg != null && this.transferToNextLeg.getTransferConstraint().isStaySeated()) {
            return null;
        }
        return this.tripPattern.getAlightType(this.alightStopPosInPattern);
    }

    @Override
    public BookingInfo dropOffBookingInfo() {
        return this.tripTimes.getDropOffBookingInfo(this.alightStopPosInPattern);
    }

    @Override
    public BookingInfo pickupBookingInfo() {
        return this.tripTimes.getPickupBookingInfo(this.boardStopPosInPattern);
    }

    @Override
    public ConstrainedTransfer transferFromPrevLeg() {
        return this.transferFromPrevLeg;
    }

    @Override
    public ConstrainedTransfer transferToNextLeg() {
        return this.transferToNextLeg;
    }

    @Override
    public Integer boardStopPosInPattern() {
        return this.boardStopPosInPattern;
    }

    @Override
    public Integer alightStopPosInPattern() {
        return this.alightStopPosInPattern;
    }

    @Override
    public Integer boardingGtfsStopSequence() {
        return this.tripTimes.gtfsSequenceOfStopIndex(this.boardStopPosInPattern);
    }

    @Override
    public Integer alightGtfsStopSequence() {
        return this.tripTimes.gtfsSequenceOfStopIndex(this.alightStopPosInPattern);
    }

    @Override
    public int generalizedCost() {
        return this.generalizedCost;
    }

    @Override
    public LegReference legReference() {
        return new ScheduledTransitLegReference(this.tripOnServiceDate == null ? this.tripTimes.getTrip().getId() : null, this.serviceDate, this.boardStopPosInPattern, this.alightStopPosInPattern, this.tripPattern.getStops().get(this.boardStopPosInPattern).getId(), this.tripPattern.getStops().get(this.alightStopPosInPattern).getId(), this.tripOnServiceDate == null ? null : this.tripOnServiceDate.getId());
    }

    @Override
    @Nullable
    public Float accessibilityScore() {
        return this.accessibilityScore;
    }

    @Override
    @Nullable
    public Emission emissionPerPerson() {
        return this.emissionPerPerson;
    }

    @Override
    @Nullable
    public Leg withEmissionPerPerson(Emission emissionPerPerson) {
        return ((ScheduledTransitLegBuilder)this.copyOf().withEmissionPerPerson(emissionPerPerson)).build();
    }

    @Override
    public List<FareOffer> fareOffers() {
        return this.fareOffers;
    }

    public String toString() {
        return ToStringBuilder.of(ScheduledTransitLeg.class).addObj("from", (Object)this.from()).addObj("to", (Object)this.to()).addTime("startTime", this.startTime).addTime("endTime", this.endTime).addBool("realTime", Boolean.valueOf(this.isRealTimeUpdated())).addNum("distance", (Number)this.distanceMeters, "m").addCost("generalizedCost", Integer.valueOf(this.generalizedCost), Integer.valueOf(Cost.ZERO.toSeconds())).addObjOp("agencyId", (Object)this.agency(), AbstractTransitEntity::getId).addNum("routeType", (Number)this.routeType()).addObjOp("routeId", (Object)this.route(), AbstractTransitEntity::getId).addObjOp("tripId", (Object)this.trip(), AbstractTransitEntity::getId).addObj("headsign", (Object)this.headsign()).addObj("serviceDate", (Object)this.serviceDate).addEnum("boardRule", (Enum)this.boardRule()).addEnum("alightRule", (Enum)this.alightRule()).addObj("transferFromPrevLeg", (Object)this.transferFromPrevLeg).addObj("transferToNextLeg", (Object)this.transferToNextLeg).addColSize("transitAlerts", this.transitAlerts).addObj("emissionPerPerson", (Object)this.emissionPerPerson).addColSize("fareProducts", this.fareOffers).toString();
    }
}

