/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.leg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.transit.model.network.TripPattern;

public class LegConstructionSupport {
    public static double computeDistanceMeters(TripPattern tripPattern, int boardStopIndexInPattern, int alightStopIndexInPattern) {
        List<Coordinate> transitLegCoordinates = LegConstructionSupport.extractTransitLegCoordinates(tripPattern, boardStopIndexInPattern, alightStopIndexInPattern);
        return GeometryUtils.sumDistances(transitLegCoordinates);
    }

    public static List<Coordinate> extractTransitLegCoordinates(TripPattern tripPattern, int boardStopIndexInPattern, int alightStopIndexInPattern) {
        ArrayList<Coordinate> transitLegCoordinates = new ArrayList<Coordinate>();
        for (int i = boardStopIndexInPattern + 1; i <= alightStopIndexInPattern; ++i) {
            transitLegCoordinates.addAll(Arrays.asList(tripPattern.getHopGeometry(i - 1).getCoordinates()));
        }
        return transitLegCoordinates;
    }
}

