/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.leg;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.model.plan.leg.LegRealTimeEstimate;

public class LegCallTime {
    private final ZonedDateTime scheduledTime;
    @Nullable
    private final LegRealTimeEstimate estimated;

    private LegCallTime(ZonedDateTime scheduledTime, @Nullable LegRealTimeEstimate estimated) {
        this.scheduledTime = Objects.requireNonNull(scheduledTime);
        this.estimated = estimated;
    }

    public static LegCallTime of(ZonedDateTime realtime, int delaySecs) {
        Duration delay = Duration.ofSeconds(delaySecs);
        return new LegCallTime(realtime.minus(delay), new LegRealTimeEstimate(realtime, delay));
    }

    public static LegCallTime ofStatic(ZonedDateTime staticTime) {
        return new LegCallTime(staticTime, null);
    }

    public ZonedDateTime scheduledTime() {
        return this.scheduledTime;
    }

    public LegRealTimeEstimate estimated() {
        return this.estimated;
    }

    public ZonedDateTime time() {
        if (this.estimated == null) {
            return this.scheduledTime;
        }
        return this.estimated.time();
    }
}

