/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.leg;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.leg.FrequencyTransitLegBuilder;
import org.opentripplanner.model.plan.leg.LegCallTime;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.utils.time.ServiceDateUtils;

public class FrequencyTransitLeg
extends ScheduledTransitLeg {
    private final int frequencyHeadwayInSeconds;

    FrequencyTransitLeg(FrequencyTransitLegBuilder builder) {
        super(builder);
        this.frequencyHeadwayInSeconds = builder.frequencyHeadwayInSeconds();
    }

    @Override
    public FrequencyTransitLegBuilder copyOf() {
        return new FrequencyTransitLegBuilder(this);
    }

    @Override
    public Boolean isNonExactFrequency() {
        return this.frequencyHeadwayInSeconds != 0;
    }

    @Override
    public Integer headway() {
        return this.frequencyHeadwayInSeconds;
    }

    @Override
    public boolean isPartiallySameTransitLeg(Leg other) {
        boolean same = super.isPartiallySameTransitLeg(other);
        if (other instanceof FrequencyTransitLeg) {
            FrequencyTransitLeg frequencyTransitLeg = (FrequencyTransitLeg)other;
            int start = this.tripTimes().getDepartureTime(0);
            int otherStart = frequencyTransitLeg.tripTimes().getDepartureTime(0);
            return same && start == otherStart;
        }
        return same;
    }

    @Override
    public List<StopArrival> listIntermediateStops() {
        ArrayList<StopArrival> visits = new ArrayList<StopArrival>();
        for (int i = this.boardStopPosInPattern + 1; i < this.alightStopPosInPattern; ++i) {
            StopLocation stop = this.tripPattern().getStop(i);
            int arrivalTime = this.tripTimes().getArrivalTime(i);
            int departureTime = this.tripTimes().getDepartureTime(i) + this.frequencyHeadwayInSeconds;
            StopArrival visit = new StopArrival(Place.forStop(stop), LegCallTime.ofStatic(ServiceDateUtils.toZonedDateTime((LocalDate)this.serviceDate(), (ZoneId)this.zoneId(), (int)arrivalTime)), LegCallTime.ofStatic(ServiceDateUtils.toZonedDateTime((LocalDate)this.serviceDate(), (ZoneId)this.zoneId(), (int)departureTime)), i, this.tripTimes().gtfsSequenceOfStopIndex(i));
            visits.add(visit);
        }
        return visits;
    }
}

