/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.leg;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class ElevationProfile {
    private static final double PRECISION = 100.0;
    private static final ElevationProfile EMPTY = new ElevationProfile();
    private final List<Step> steps;
    private Double gained = null;
    private Double lost = null;

    private ElevationProfile() {
        this.steps = List.of();
    }

    private ElevationProfile(Builder builder) {
        this.steps = List.copyOf(builder.steps);
    }

    public static ElevationProfile empty() {
        return EMPTY;
    }

    public static Builder of() {
        return ElevationProfile.empty().copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double elevationGained() {
        if (this.gained == null) {
            this.gained = ElevationProfile.calculateElevationChange(this.steps, v -> v > 0.0);
        }
        return this.gained;
    }

    public double elevationLost() {
        if (this.lost == null) {
            this.lost = ElevationProfile.calculateElevationChange(this.steps, v -> v < 0.0);
        }
        return this.lost;
    }

    public ElevationProfile add(ElevationProfile other) {
        return this.copyOf().add(other).build();
    }

    public ElevationProfile transformX(double dx) {
        return this.copyOf().transformX(dx).build();
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    public boolean isAllYUnknown() {
        return !this.isEmpty() && this.steps.stream().allMatch(Step::isYUnknown);
    }

    public List<Step> steps() {
        return this.steps;
    }

    public List<Step> stepsWithoutUnknowns() {
        return this.steps.stream().filter(step -> !step.isYUnknown()).toList();
    }

    public String toString() {
        return ToStringBuilder.of(ElevationProfile.class).addCol("steps", this.steps).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElevationProfile that = (ElevationProfile)o;
        return Objects.equals(this.steps, that.steps);
    }

    public int hashCode() {
        return Objects.hash(this.steps);
    }

    private static Double calculateElevationChange(List<Step> profile, Predicate<Double> elevationFilter) {
        if (profile == null) {
            return null;
        }
        double sum = 0.0;
        boolean first = true;
        double prevElevation = 0.0;
        for (Step p2 : profile) {
            double change;
            double elevation = p2.y();
            if (!first && elevationFilter.test(change = elevation - prevElevation)) {
                sum += Math.abs(change);
            }
            prevElevation = elevation;
            first = false;
        }
        return DoubleUtils.roundTo2Decimals((double)sum);
    }

    public static class Builder {
        private final ElevationProfile original;
        private final List<Step> steps = new ArrayList<Step>();

        public Builder(ElevationProfile original) {
            this.original = original;
            this.steps.addAll(original.steps);
        }

        public Builder step(double x, double y) {
            if (Double.isNaN(y)) {
                return this.stepYUnknown(x);
            }
            this.steps.add(new Step(x, y));
            return this;
        }

        public Builder stepYUnknown(double x) {
            this.steps.add(new Step(x));
            return this;
        }

        public Builder add(ElevationProfile other) {
            this.steps.addAll(other.steps);
            return this;
        }

        public Builder transformX(double dx) {
            this.steps.replaceAll(s -> s.transformX(dx));
            return this;
        }

        public ElevationProfile build() {
            if (this.steps.size() == this.original.steps.size()) {
                return this.original;
            }
            this.removeDuplicateSteps();
            return new ElevationProfile(this);
        }

        private void removeDuplicateSteps() {
            for (int i = this.steps.size() - 3; i >= 0; --i) {
                Step first = this.steps.get(i);
                Step second = this.steps.get(i + 1);
                Step third = this.steps.get(i + 2);
                if (first.y == second.y && second.y == third.y) {
                    this.steps.remove(i + 1);
                    continue;
                }
                if (first.equals(second)) {
                    this.steps.remove(i + 1);
                    continue;
                }
                if (!second.equals(third)) continue;
                this.steps.remove(i + 1);
            }
        }
    }

    public static class Step {
        private static final int UNKNOWN = -9999999;
        private final int x;
        private final int y;

        Step(int x, int y) {
            this.x = x;
            this.y = y;
        }

        Step(double x, double y) {
            this(Step.valueToInt(x), Step.valueToInt(y));
        }

        Step(double x) {
            this(Step.valueToInt(x), -9999999);
        }

        public double x() {
            return this.valueToDouble(this.x);
        }

        public double y() {
            return this.y == -9999999 ? Double.NaN : this.valueToDouble(this.y);
        }

        public boolean isYUnknown() {
            return this.y == -9999999;
        }

        public String toString() {
            return "[" + this.x() + ", " + String.valueOf(this.isYUnknown() ? "UNKNOWN" : Double.valueOf(this.y())) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Step that = (Step)o;
            return that.x == this.x && that.y == this.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        Step transformX(double dx) {
            return new Step(Step.valueToInt(this.x() + dx), this.y);
        }

        private static int valueToInt(double v) {
            return (int)((v + 0.005) * 100.0);
        }

        private double valueToDouble(double v) {
            return v / 100.0;
        }
    }
}

