/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.grouppriority;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.raptor.api.request.RaptorTransitGroupPriorityCalculator;
import org.opentripplanner.transit.model.network.grouppriority.DefaultTransitGroupPriorityCalculator;
import org.opentripplanner.transit.model.network.grouppriority.TransitGroupPriorityService;

public class TransitGroupPriorityItineraryDecorator {
    private final TransitGroupPriorityService priorityGroupConfigurator;
    private final RaptorTransitGroupPriorityCalculator transitGroupCalculator;

    public TransitGroupPriorityItineraryDecorator(TransitGroupPriorityService priorityGroupConfigurator) {
        this.priorityGroupConfigurator = priorityGroupConfigurator;
        this.transitGroupCalculator = new DefaultTransitGroupPriorityCalculator();
    }

    public List<Itinerary> decorate(List<Itinerary> itineraries) {
        if (!this.priorityGroupConfigurator.isEnabled() || TransitGroupPriorityItineraryDecorator.isC2SetForAllItineraries(itineraries)) {
            return itineraries;
        }
        ArrayList<Itinerary> list = new ArrayList<Itinerary>();
        for (Itinerary it : itineraries) {
            list.add(this.decorate(it));
        }
        return list;
    }

    private Itinerary decorate(Itinerary itinerary) {
        if (!itinerary.generalizedCost2().isEmpty()) {
            return itinerary;
        }
        int c2 = this.priorityGroupConfigurator.baseGroupId();
        for (Leg leg : itinerary.legs()) {
            if (leg.trip() == null) continue;
            int newGroupId = this.priorityGroupConfigurator.lookupTransitGroupPriorityId(leg.trip());
            c2 = this.transitGroupCalculator.mergeInGroupId(c2, newGroupId);
        }
        return itinerary.copyOf().withGeneralizedCost2(c2).build();
    }

    private static boolean isC2SetForAllItineraries(List<Itinerary> itineraries) {
        return itineraries.stream().allMatch(it -> it.generalizedCost2().isPresent());
    }
}

