/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.leg.ElevationProfile;
import org.opentripplanner.model.plan.leg.LegCallTime;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.model.plan.walkstep.WalkStep;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.street.model.note.StreetNote;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;

public interface Leg {
    public boolean isTransitLeg();

    default public boolean isScheduledTransitLeg() {
        return false;
    }

    default public ScheduledTransitLeg asScheduledTransitLeg() {
        throw new ClassCastException();
    }

    default public Boolean isInterlinedWithPreviousLeg() {
        return false;
    }

    default public boolean isWalkingLeg() {
        return false;
    }

    default public boolean isStreetLeg() {
        return false;
    }

    default public Duration duration() {
        return Duration.between(this.startTime(), this.endTime());
    }

    default public boolean isPartiallySameTransitLeg(Leg other) {
        if (!this.isTransitLeg() || !other.isTransitLeg()) {
            throw new IllegalStateException();
        }
        if (!this.serviceDate().equals(other.serviceDate())) {
            return false;
        }
        if (!this.trip().getId().equals(other.trip().getId())) {
            return false;
        }
        return this.boardStopPosInPattern() < other.alightStopPosInPattern() && this.alightStopPosInPattern() > other.boardStopPosInPattern();
    }

    public boolean hasSameMode(Leg var1);

    default public boolean isPartiallySameLeg(Leg other) {
        if (!this.hasSameMode(other)) {
            return false;
        }
        if (!this.overlapInTime(other)) {
            return false;
        }
        if (this.isStreetLeg()) {
            return true;
        }
        if (!this.trip().getId().equals(other.trip().getId())) {
            return false;
        }
        return this.boardStopPosInPattern() < other.alightStopPosInPattern() && this.alightStopPosInPattern() > other.boardStopPosInPattern();
    }

    default public boolean overlapInTime(Leg other) {
        return this.startTime().toEpochSecond() < other.endTime().toEpochSecond() && other.startTime().toEpochSecond() < this.endTime().toEpochSecond();
    }

    @Nullable
    default public Agency agency() {
        return null;
    }

    @Nullable
    default public Operator operator() {
        return null;
    }

    @Nullable
    default public Route route() {
        return null;
    }

    @Nullable
    default public Trip trip() {
        return null;
    }

    @Nullable
    default public TripOnServiceDate tripOnServiceDate() {
        return null;
    }

    @Nullable
    default public Accessibility tripWheelchairAccessibility() {
        return null;
    }

    public LegCallTime start();

    public LegCallTime end();

    public ZonedDateTime startTime();

    public ZonedDateTime endTime();

    default public int departureDelay() {
        return 0;
    }

    default public int arrivalDelay() {
        return 0;
    }

    default public boolean isRealTimeUpdated() {
        return false;
    }

    @Nullable
    default public RealTimeState realTimeState() {
        return null;
    }

    default public boolean isFlexibleTrip() {
        return false;
    }

    @Nullable
    default public Boolean isNonExactFrequency() {
        return null;
    }

    @Nullable
    default public Integer headway() {
        return null;
    }

    public double distanceMeters();

    default public int agencyTimeZoneOffset() {
        int MILLIS_TO_SECONDS = 1000;
        return this.startTime().getOffset().getTotalSeconds() * MILLIS_TO_SECONDS;
    }

    @Nullable
    default public Integer routeType() {
        return null;
    }

    @Nullable
    default public I18NString headsign() {
        return null;
    }

    @Nullable
    default public LocalDate serviceDate() {
        return null;
    }

    @Nullable
    default public String routeBrandingUrl() {
        return null;
    }

    public Place from();

    public Place to();

    @Nullable
    default public List<StopArrival> listIntermediateStops() {
        return null;
    }

    @Nullable
    public LineString legGeometry();

    @Nullable
    default public ElevationProfile elevationProfile() {
        return null;
    }

    default public List<WalkStep> listWalkSteps() {
        return List.of();
    }

    default public Set<StreetNote> listStreetNotes() {
        return Set.of();
    }

    public Set<TransitAlert> listTransitAlerts();

    @Nullable
    default public PickDrop boardRule() {
        return null;
    }

    @Nullable
    default public PickDrop alightRule() {
        return null;
    }

    @Nullable
    default public BookingInfo dropOffBookingInfo() {
        return null;
    }

    @Nullable
    default public BookingInfo pickupBookingInfo() {
        return null;
    }

    @Nullable
    default public ConstrainedTransfer transferFromPrevLeg() {
        return null;
    }

    @Nullable
    default public ConstrainedTransfer transferToNextLeg() {
        return null;
    }

    @Nullable
    default public Integer boardStopPosInPattern() {
        return null;
    }

    @Nullable
    default public Integer alightStopPosInPattern() {
        return null;
    }

    @Nullable
    default public Integer boardingGtfsStopSequence() {
        return null;
    }

    @Nullable
    default public Integer alightGtfsStopSequence() {
        return null;
    }

    @Nullable
    default public Boolean walkingBike() {
        return null;
    }

    @Nullable
    default public Float accessibilityScore() {
        return null;
    }

    @Nullable
    public Emission emissionPerPerson();

    @Nullable
    public Leg withEmissionPerPerson(Emission var1);

    @Nullable
    default public Boolean rentedVehicle() {
        return null;
    }

    @Nullable
    default public String vehicleRentalNetwork() {
        return null;
    }

    public int generalizedCost();

    @Nullable
    default public LegReference legReference() {
        return null;
    }

    default public Leg withTimeShift(Duration duration) {
        throw new UnsupportedOperationException();
    }

    default public Set<FareZone> fareZones() {
        Stream intermediate = this.listIntermediateStops().stream().flatMap(stopArrival -> stopArrival.place.stop.getFareZones().stream());
        Stream<FareZone> start = Leg.fareZones(this.from());
        Stream<FareZone> end = Leg.fareZones(this.to());
        return Stream.of(intermediate, start, end).flatMap(s -> s).collect(Collectors.toSet());
    }

    public List<FareOffer> fareOffers();

    private static Stream<FareZone> fareZones(Place place) {
        if (place.stop == null) {
            return Stream.empty();
        }
        return place.stop.getFareZones().stream();
    }
}

