/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.TimeAndCost;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.fare.ItineraryFare;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.TransitLeg;

public class ItineraryBuilder {
    final boolean searchWindowAware;
    TimeAndCost accessPenalty = TimeAndCost.ZERO;
    TimeAndCost egressPenalty = TimeAndCost.ZERO;
    Cost generalizedCost = null;
    Integer generalizedCost2 = null;
    int transferPriorityCost = -1;
    int waitTimeOptimizedCost = -1;
    boolean arrivedAtDestinationWithRentedVehicle = false;
    Double elevationGained_m = 0.0;
    Double elevationLost_m = 0.0;
    Double maxSlope = null;
    boolean tooSloped = false;
    List<Leg> legs;
    final List<SystemNotice> systemNotices;
    Float accessibilityScore;
    Emission emissionPerPerson;
    ItineraryFare fare = ItineraryFare.empty();

    ItineraryBuilder(List<Leg> legs, boolean searchWindowAware) {
        this.legs = legs;
        this.searchWindowAware = searchWindowAware;
        this.systemNotices = new ArrayList<SystemNotice>();
    }

    ItineraryBuilder(Itinerary original) {
        this.legs = original.legs();
        this.searchWindowAware = original.isSearchWindowAware();
        this.accessPenalty = original.accessPenalty();
        this.egressPenalty = original.egressPenalty();
        this.generalizedCost = original.generalizedCostIncludingPenalty();
        this.generalizedCost2 = original.generalizedCost2().orElse(null);
        this.transferPriorityCost = original.transferPriorityCost();
        this.waitTimeOptimizedCost = original.waitTimeOptimizedCost();
        this.elevationGained_m = original.privateElevationGainedForBuilder();
        this.elevationLost_m = original.privateElevationLostForBuilder();
        this.tooSloped = original.isTooSloped();
        this.maxSlope = original.maxSlope();
        this.arrivedAtDestinationWithRentedVehicle = original.isArrivedAtDestinationWithRentedVehicle();
        this.systemNotices = original.privateSystemNoticesForBuilder();
        this.accessibilityScore = original.accessibilityScore();
        this.emissionPerPerson = original.emissionPerPerson();
        this.fare = original.fare();
    }

    public ItineraryBuilder withGeneralizedCost(Cost generalizedCost) {
        this.generalizedCost = generalizedCost;
        return this;
    }

    Cost calculateGeneralizedCostWithoutPenalty() {
        return this.generalizedCost.minus(this.accessPenalty.cost().plus(this.egressPenalty.cost()));
    }

    public ItineraryBuilder withGeneralizedCost2(Integer generalizedCost2) {
        this.generalizedCost2 = generalizedCost2;
        return this;
    }

    public ItineraryBuilder withTransferPriorityCost(int transferPriorityCost) {
        this.transferPriorityCost = transferPriorityCost;
        return this;
    }

    public ItineraryBuilder withWaitTimeOptimizedCost(int waitTimeOptimizedCost) {
        this.waitTimeOptimizedCost = waitTimeOptimizedCost;
        return this;
    }

    public ItineraryBuilder withAccessPenalty(TimeAndCost accessPenalty) {
        this.accessPenalty = accessPenalty;
        return this;
    }

    public ItineraryBuilder withEgressPenalty(TimeAndCost egressPenalty) {
        this.egressPenalty = egressPenalty;
        return this;
    }

    public void addElevationChange(double change_m) {
        if (change_m > 0.0) {
            this.elevationGained_m = this.elevationGained_m + change_m;
        } else {
            this.elevationLost_m = this.elevationLost_m - change_m;
        }
    }

    public ItineraryBuilder withMaxSlope(double wheelchairPreferencesMaxSlope, double maxSlope) {
        this.maxSlope = maxSlope;
        this.tooSloped = maxSlope > wheelchairPreferencesMaxSlope;
        return this;
    }

    public ItineraryBuilder withArrivedAtDestinationWithRentedVehicle(boolean arrivedAtDestinationWithRentedVehicle) {
        this.arrivedAtDestinationWithRentedVehicle = arrivedAtDestinationWithRentedVehicle;
        return this;
    }

    public List<Leg> legs() {
        return this.legs;
    }

    public ItineraryBuilder withLegs(List<Leg> newLegs) {
        this.legs = newLegs;
        return this;
    }

    public ItineraryBuilder transformLegs(Function<Leg, Leg> legMapper) {
        return this.withLegs(this.legs.stream().map(legMapper).toList());
    }

    public ItineraryBuilder transformTransitLegs(Function<TransitLeg, TransitLeg> mapper) {
        this.legs = this.legs.stream().map(l -> {
            if (l instanceof TransitLeg) {
                TransitLeg tl = (TransitLeg)l;
                return (Leg)mapper.apply(tl);
            }
            return l;
        }).toList();
        return this;
    }

    public ItineraryBuilder withAccessibilityScore(Float accessibilityScore) {
        this.accessibilityScore = accessibilityScore;
        return this;
    }

    public ItineraryBuilder withEmissionPerPerson(Emission emissionPerPerson) {
        this.emissionPerPerson = emissionPerPerson;
        return this;
    }

    public ItineraryFare fare() {
        return this.fare;
    }

    public ItineraryBuilder withFare(ItineraryFare fare) {
        this.fare = fare;
        return this;
    }

    public Itinerary build() {
        return new Itinerary(this);
    }
}

