/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.ext.flex.FlexibleTransitLeg;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.TimeAndCost;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.fare.ItineraryFare;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.ItinerariesCalculateLegTotals;
import org.opentripplanner.model.plan.ItineraryBuilder;
import org.opentripplanner.model.plan.ItinerarySortKey;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.model.plan.leg.StreetLeg;
import org.opentripplanner.raptor.api.path.PathStringBuilder;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class Itinerary
implements ItinerarySortKey {
    public static final int UNKNOWN = -1;
    private final Duration totalDuration;
    private final boolean searchWindowAware;
    private final TimeAndCost accessPenalty;
    private final TimeAndCost egressPenalty;
    private final Cost generalizedCost;
    @Nullable
    private final Integer generalizedCost2;
    private final int transferPriorityCost;
    private final int waitTimeOptimizedCost;
    private final int numberOfTransfers;
    private final Duration totalTransitDuration;
    private final double totalStreetDistanceMeters;
    private final Duration totalStreetDuration;
    private final boolean streetOnly;
    private final double totalWalkDistanceMeters;
    private final Duration totalWalkDuration;
    private final boolean walkOnly;
    private final boolean arrivedAtDestinationWithRentedVehicle;
    private final Duration totalWaitingDuration;
    private final double elevationGained_edges_m;
    private final double totalElevationGained_m;
    private final double elevationLost_edges_m;
    private final double totalElevationLost_m;
    private final Double maxSlope;
    private final boolean tooSloped;
    private final List<Leg> legs;
    private final List<SystemNotice> systemNotices;
    private final Float accessibilityScore;
    private final Emission emissionPerPerson;
    private final ItineraryFare fare;

    Itinerary(ItineraryBuilder builder) {
        this.legs = List.copyOf(builder.legs);
        this.generalizedCost = Objects.requireNonNull(builder.calculateGeneralizedCostWithoutPenalty());
        this.generalizedCost2 = builder.generalizedCost2;
        this.searchWindowAware = builder.searchWindowAware;
        this.transferPriorityCost = builder.transferPriorityCost;
        this.waitTimeOptimizedCost = builder.waitTimeOptimizedCost;
        this.accessPenalty = Objects.requireNonNull(builder.accessPenalty);
        this.egressPenalty = Objects.requireNonNull(builder.egressPenalty);
        this.tooSloped = builder.tooSloped;
        this.maxSlope = builder.maxSlope;
        this.elevationGained_edges_m = builder.elevationGained_m;
        this.elevationLost_edges_m = builder.elevationLost_m;
        this.arrivedAtDestinationWithRentedVehicle = builder.arrivedAtDestinationWithRentedVehicle;
        this.systemNotices = builder.systemNotices;
        this.accessibilityScore = builder.accessibilityScore;
        this.emissionPerPerson = builder.emissionPerPerson;
        this.fare = builder.fare;
        ItinerariesCalculateLegTotals totals = new ItinerariesCalculateLegTotals(this.legs);
        this.totalDuration = totals.totalDuration;
        this.streetOnly = totals.streetOnly;
        this.numberOfTransfers = totals.transfers();
        this.totalTransitDuration = totals.transitDuration;
        this.totalStreetDuration = totals.onStreetDuration;
        this.totalStreetDistanceMeters = DoubleUtils.roundTo2Decimals((double)totals.onStreetDistanceMeters);
        this.totalWalkDuration = totals.walkDuration;
        this.totalWalkDistanceMeters = totals.walkDistanceMeters;
        this.walkOnly = totals.walkOnly;
        this.totalWaitingDuration = totals.waitingDuration;
        this.totalElevationGained_m = totals.elevationGained_m;
        this.totalElevationLost_m = totals.elevationLost_m;
    }

    public static ItineraryBuilder ofScheduledTransit(List<Leg> legs) {
        return new ItineraryBuilder(legs, true);
    }

    public static ItineraryBuilder ofDirect(List<Leg> legs) {
        return new ItineraryBuilder(legs, false);
    }

    public ItineraryBuilder copyOf() {
        return new ItineraryBuilder(this);
    }

    public ZonedDateTime startTime() {
        return this.legs().getFirst().startTime();
    }

    @Override
    public Instant startTimeAsInstant() {
        return this.legs().getFirst().startTime().toInstant();
    }

    public ZonedDateTime endTime() {
        return this.legs().getLast().endTime();
    }

    @Override
    public Instant endTimeAsInstant() {
        return this.legs().getLast().endTime().toInstant();
    }

    public int departureDelay() {
        return this.legs().getFirst().departureDelay();
    }

    public int arrivalDelay() {
        return this.legs().getLast().arrivalDelay();
    }

    public Duration effectiveDuration() {
        return this.totalTransitDuration().plus(this.totalStreetDuration());
    }

    public double distanceMeters() {
        return this.legs().stream().filter(l -> l.distanceMeters() > 0.0).mapToDouble(Leg::distanceMeters).sum();
    }

    public boolean isDirectFlex() {
        boolean containsFlex = this.legs.stream().anyMatch(Leg::isFlexibleTrip);
        boolean flexOrWalkOnly = this.legs.stream().allMatch(l -> l.isFlexibleTrip() || l.isWalkingLeg());
        return containsFlex && flexOrWalkOnly;
    }

    public boolean hasTransit() {
        return this.legs.stream().anyMatch(l -> l instanceof ScheduledTransitLeg || l instanceof FlexibleTransitLeg);
    }

    public boolean isSearchWindowAware() {
        return this.searchWindowAware;
    }

    public void flagForDeletion(SystemNotice notice) {
        this.systemNotices.add(notice);
    }

    public void removeDeletionFlags(Set<String> removeTags) {
        this.systemNotices.removeIf(it -> removeTags.contains(it.tag()));
    }

    public boolean isFlaggedForDeletion() {
        return !this.systemNotices.isEmpty();
    }

    public boolean hasSystemNoticeTag(String tag) {
        return this.systemNotices.stream().map(SystemNotice::tag).anyMatch(tag::equals);
    }

    public Itinerary withTimeShiftToStartAt(ZonedDateTime afterTime) {
        Duration duration = Duration.between(this.legs().getFirst().startTime(), afterTime);
        List<Leg> timeShiftedLegs = this.legs().stream().map(leg -> leg.withTimeShift(duration)).collect(Collectors.toList());
        return new ItineraryBuilder(timeShiftedLegs, this.searchWindowAware).withGeneralizedCost(this.generalizedCost).withAccessPenalty(this.accessPenalty).withEgressPenalty(this.egressPenalty).build();
    }

    public Duration totalDuration() {
        return this.totalDuration;
    }

    public Duration totalTransitDuration() {
        return this.totalTransitDuration;
    }

    @Override
    public int numberOfTransfers() {
        return this.numberOfTransfers;
    }

    public Duration totalWaitingDuration() {
        return this.totalWaitingDuration;
    }

    public double totalStreetDistanceMeters() {
        return this.totalStreetDistanceMeters;
    }

    public boolean isWalkOnly() {
        return this.walkOnly;
    }

    @Override
    public boolean isStreetOnly() {
        return this.streetOnly;
    }

    public List<SystemNotice> systemNotices() {
        return List.copyOf(this.systemNotices);
    }

    List<SystemNotice> privateSystemNoticesForBuilder() {
        return this.systemNotices;
    }

    public List<Leg> legs() {
        return this.legs;
    }

    public Stream<StreetLeg> streetLegs() {
        return this.legs.stream().filter(StreetLeg.class::isInstance).map(StreetLeg.class::cast);
    }

    public TransitLeg transitLeg(int index) {
        return (TransitLeg)this.legs.get(index);
    }

    public StreetLeg streetLeg(int index) {
        return (StreetLeg)this.legs.get(index);
    }

    public Float accessibilityScore() {
        return this.accessibilityScore;
    }

    public Duration totalStreetDuration() {
        return this.totalStreetDuration;
    }

    public Double totalElevationGained() {
        return DoubleUtils.roundTo2Decimals((double)(this.elevationGained_edges_m + this.totalElevationGained_m));
    }

    double privateElevationGainedForBuilder() {
        return this.elevationGained_edges_m;
    }

    public Double totalElevationLost() {
        return DoubleUtils.roundTo2Decimals((double)(this.elevationLost_edges_m + this.totalElevationLost_m));
    }

    double privateElevationLostForBuilder() {
        return this.elevationLost_edges_m;
    }

    public int generalizedCost() {
        return this.generalizedCost.toSeconds();
    }

    @Override
    public Cost generalizedCostIncludingPenalty() {
        return this.generalizedCost.plus(this.accessPenalty.cost().plus(this.egressPenalty.cost()));
    }

    public Optional<Integer> generalizedCost2() {
        return Optional.ofNullable(this.generalizedCost2);
    }

    @Nullable
    public TimeAndCost accessPenalty() {
        return this.accessPenalty;
    }

    @Nullable
    public TimeAndCost egressPenalty() {
        return this.egressPenalty;
    }

    public int waitTimeOptimizedCost() {
        return this.waitTimeOptimizedCost;
    }

    public int transferPriorityCost() {
        return this.transferPriorityCost;
    }

    public boolean isTooSloped() {
        return this.tooSloped;
    }

    public Double maxSlope() {
        return this.maxSlope;
    }

    public boolean isArrivedAtDestinationWithRentedVehicle() {
        return this.arrivedAtDestinationWithRentedVehicle;
    }

    public List<ScheduledTransitLeg> listScheduledTransitLegs() {
        return this.legs().stream().filter(ScheduledTransitLeg.class::isInstance).map(ScheduledTransitLeg.class::cast).toList();
    }

    @Nullable
    public Emission emissionPerPerson() {
        return this.emissionPerPerson;
    }

    public double totalWalkDistanceMeters() {
        return this.totalWalkDistanceMeters;
    }

    public Duration totalWalkDuration() {
        return this.totalWalkDuration;
    }

    public ItineraryFare fare() {
        return this.fare;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return ToStringBuilder.of(Itinerary.class).addStr("from", this.legs().getFirst().from().toStringShort()).addStr("to", this.legs().getLast().to().toStringShort()).addTime("start", this.legs().getFirst().startTime()).addTime("end", this.legs().getLast().endTime()).addNum("nTransfers", (Number)this.numberOfTransfers).addDuration("duration", this.totalDuration).addDuration("nonTransitTime", this.totalStreetDuration).addDuration("transitTime", this.totalTransitDuration).addDuration("waitingTime", this.totalWaitingDuration).addObj("generalizedCost", (Object)this.generalizedCost).addNum("generalizedCost2", (Number)this.generalizedCost2).addNum("waitTimeOptimizedCost", (Number)this.waitTimeOptimizedCost, (Number)-1).addNum("transferPriorityCost", (Number)this.transferPriorityCost, (Number)-1).addNum("nonTransitDistance", (Number)this.totalStreetDistanceMeters, "m").addBool("tooSloped", Boolean.valueOf(this.tooSloped)).addNum("elevationGained", (Number)this.totalElevationGained(), "m").addNum("elevationLost", (Number)this.totalElevationLost(), "m").addCol("legs", this.legs).addObj("emissionPerPerson", (Object)this.emissionPerPerson).addObj("fare", (Object)this.fare).toString();
    }

    public static String toStr(List<Itinerary> list) {
        return list.stream().map(Itinerary::toStr).collect(Collectors.joining(", "));
    }

    public String toStr() {
        PathStringBuilder buf = new PathStringBuilder(null);
        buf.stop(this.legs().getFirst().from().name.toString());
        for (Leg leg : this.legs) {
            if (leg.isWalkingLeg()) {
                buf.walk((int)leg.duration().toSeconds());
            } else if (leg instanceof TransitLeg) {
                TransitLeg transitLeg = (TransitLeg)leg;
                buf.transit(transitLeg.mode().name(), transitLeg.trip().logName(), transitLeg.startTime(), transitLeg.endTime());
            } else if (leg instanceof StreetLeg) {
                StreetLeg streetLeg = (StreetLeg)leg;
                buf.street(streetLeg.getMode().name(), leg.startTime(), leg.endTime());
            }
            buf.stop(leg.to().name.toString());
        }
        buf.summary(this.generalizedCost.toCentiSeconds(), this.generalizedCost2().orElse(-1999000000).intValue());
        return buf.toString();
    }
}

