/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.Duration;
import java.util.List;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ElevationProfile;
import org.opentripplanner.model.plan.leg.UnknownPathLeg;

class ItinerariesCalculateLegTotals {
    Duration totalDuration = Duration.ZERO;
    Duration transitDuration = Duration.ZERO;
    int nTransitLegs = 0;
    Duration onStreetDuration = Duration.ZERO;
    double onStreetDistanceMeters = 0.0;
    Duration walkDuration = Duration.ZERO;
    double walkDistanceMeters = 0.0;
    Duration waitingDuration = Duration.ZERO;
    boolean walkOnly = true;
    boolean streetOnly = true;
    double elevationGained_m = 0.0;
    double elevationLost_m = 0.0;

    public ItinerariesCalculateLegTotals(List<Leg> legs) {
        if (legs.isEmpty()) {
            return;
        }
        this.calculate(legs);
    }

    int transfers() {
        return this.nTransitLegs == 0 ? 0 : this.nTransitLegs - 1;
    }

    private void calculate(List<Leg> legs) {
        this.totalDuration = Duration.between(legs.getFirst().startTime(), legs.getLast().endTime());
        for (Leg leg : legs) {
            Duration dt = leg.duration();
            if (leg.isTransitLeg()) {
                this.transitDuration = this.transitDuration.plus(dt);
                if (!leg.isInterlinedWithPreviousLeg().booleanValue()) {
                    ++this.nTransitLegs;
                }
            } else if (leg.isStreetLeg()) {
                this.onStreetDuration = this.onStreetDuration.plus(dt);
                this.onStreetDistanceMeters += leg.distanceMeters();
                if (leg.isWalkingLeg()) {
                    this.walkDuration = this.walkDuration.plus(leg.duration());
                    this.walkDistanceMeters += leg.distanceMeters();
                }
            } else if (leg instanceof UnknownPathLeg) {
                UnknownPathLeg unknownPathLeg = (UnknownPathLeg)leg;
                this.nTransitLegs += unknownPathLeg.getNumberOfTransfers() + 1;
            }
            if (!leg.isWalkingLeg()) {
                this.walkOnly = false;
            }
            if (!leg.isStreetLeg()) {
                this.streetOnly = false;
            }
            if (leg.elevationProfile() == null) continue;
            ElevationProfile p = leg.elevationProfile();
            this.elevationGained_m += p.elevationGained();
            this.elevationLost_m += p.elevationLost();
        }
        this.waitingDuration = this.totalDuration.minus(this.transitDuration).minus(this.onStreetDuration);
    }
}

