/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.io.Serializable;
import java.util.Objects;
import org.opentripplanner.framework.model.Gram;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class Emission
implements Serializable {
    public static final Emission ZERO = new Emission(Gram.ZERO);
    private final Gram co2;

    private Emission(Gram co2) {
        this.co2 = Objects.requireNonNull(co2);
    }

    public static Emission of(Gram co2) {
        return new Emission(co2);
    }

    public static Emission ofCo2Gram(double co2_g) {
        return new Emission(Gram.of(co2_g));
    }

    public Gram co2() {
        return this.co2;
    }

    public Emission plus(Emission right) {
        return new Emission(this.co2.plus(right.co2));
    }

    public Emission multiply(double multiplier) {
        return new Emission(this.co2.multiply(multiplier));
    }

    public Emission dividedBy(double divisor) {
        return new Emission(this.co2.dividedBy(divisor));
    }

    public boolean isZero() {
        return this.co2.isZero();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.co2.equals(((Emission)o).co2);
    }

    public int hashCode() {
        return Objects.hashCode(this.co2);
    }

    public String toString() {
        return ToStringBuilder.of(Emission.class).addObj("CO\u2082", (Object)this.co2, (Object)Gram.ZERO).toString();
    }
}

