/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.modes;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.opentripplanner.model.modes.AllowMainModeFilter;
import org.opentripplanner.model.modes.AllowTransitModeFilter;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.utils.tostring.ToStringBuilder;

class AllowMainModesFilter
implements AllowTransitModeFilter {
    private final Set<TransitMode> mainModes;

    AllowMainModesFilter(Collection<AllowMainModeFilter> filters) {
        this.mainModes = EnumSet.copyOf(filters.stream().map(AllowMainModeFilter::mainMode).toList());
    }

    @Override
    public boolean match(TransitMode transitMode, SubMode ignore) {
        return this.mainModes.contains(transitMode);
    }

    public int hashCode() {
        return this.mainModes.hashCode() + 176393;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllowMainModesFilter that = (AllowMainModesFilter)o;
        return this.mainModes.equals(that.mainModes);
    }

    public String toString() {
        return ToStringBuilder.of(AllowMainModesFilter.class).addCol("mainModes", this.mainModes).toString();
    }
}

