/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.modes;

import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.model.modes.AllowMainAndSubModeFilter;
import org.opentripplanner.model.modes.AllowTransitModeFilter;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.utils.tostring.ToStringBuilder;

class AllowMainAndSubModesFilter
implements AllowTransitModeFilter {
    private final TransitMode mainMode;
    private final BitSet subModes;

    AllowMainAndSubModesFilter(Collection<AllowMainAndSubModeFilter> filters) {
        this.mainMode = filters.iterator().next().mainMode();
        this.subModes = new BitSet();
        for (AllowMainAndSubModeFilter it : filters) {
            if (it.mainMode() != this.mainMode) {
                throw new IllegalArgumentException("Main mode is not the same: " + String.valueOf(filters));
            }
            this.subModes.set(it.subMode().index());
        }
    }

    @Override
    public boolean isSubMode() {
        return true;
    }

    @Override
    public boolean match(TransitMode transitMode, SubMode subMode) {
        return this.mainMode == transitMode && this.includesSubMode(subMode);
    }

    public int hashCode() {
        return Objects.hash(this.mainMode, this.subModes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllowMainAndSubModesFilter that = (AllowMainAndSubModesFilter)o;
        return this.mainMode == that.mainMode && this.subModes.equals(that.subModes);
    }

    public String toString() {
        List<SubMode> subModes = SubMode.getByIndex(this.subModes).stream().sorted(Comparator.comparing(SubMode::name)).toList();
        return ToStringBuilder.of(AllowMainAndSubModesFilter.class).addEnum("mainMode", (Enum)this.mainMode).addCol("subModes", subModes).toString();
    }

    private boolean includesSubMode(SubMode subMode) {
        return this.subModes.get(subMode.index());
    }
}

