/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.modes;

import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.model.modes.AllowTransitModeFilter;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.utils.tostring.ToStringBuilder;

class AllowMainAndSubModeFilter
implements AllowTransitModeFilter {
    private final TransitMode mainMode;
    private final SubMode subMode;

    AllowMainAndSubModeFilter(TransitMode mainMode, @Nullable SubMode subMode) {
        this.mainMode = mainMode;
        this.subMode = subMode;
    }

    AllowMainAndSubModeFilter(MainAndSubMode mode) {
        this(mode.mainMode(), mode.subMode());
    }

    @Override
    public boolean isSubMode() {
        return true;
    }

    @Override
    public boolean match(TransitMode transitMode, SubMode netexSubMode) {
        return this.mainMode == transitMode && this.subMode == netexSubMode;
    }

    TransitMode mainMode() {
        return this.mainMode;
    }

    @Nullable
    SubMode subMode() {
        return this.subMode;
    }

    public int hashCode() {
        return Objects.hash(this.mainMode, this.subMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllowMainAndSubModeFilter that = (AllowMainAndSubModeFilter)o;
        return this.mainMode == that.mainMode && this.subMode.equals(that.subMode);
    }

    public String toString() {
        return ToStringBuilder.of(AllowMainAndSubModeFilter.class).addEnum("mainMode", (Enum)this.mainMode).addObj("subMode", (Object)this.subMode).toString();
    }
}

