/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.BoardingArea;
import org.opentripplanner.transit.model.site.Entrance;
import org.opentripplanner.transit.model.site.Pathway;
import org.opentripplanner.transit.model.site.PathwayNode;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.SiteRepository;

class OtpTransitServiceImpl
implements OtpTransitService {
    private final Collection<Agency> agencies;
    private final Collection<Operator> operators;
    private final Collection<FeedInfo> feedInfos;
    private final SiteRepository siteRepository;
    private final ImmutableListMultimap<AbstractTransitEntity, Notice> noticeAssignments;
    private final Collection<Pathway> pathways;
    private final Collection<FeedScopedId> serviceIds;
    private final Map<FeedScopedId, Entrance> entrancesById;
    private final Map<FeedScopedId, PathwayNode> pathwayNodesById;
    private final Map<FeedScopedId, BoardingArea> boardingAreasById;
    private final Collection<ConstrainedTransfer> transfers;
    private final Collection<TripPattern> tripPatterns;
    private final Collection<Trip> trips;
    private final Collection<FlexTrip<?, ?>> flexTrips;
    private final Map<FeedScopedId, RegularStop> stopsByScheduledStopPoint;

    OtpTransitServiceImpl(OtpTransitServiceBuilder builder) {
        this.agencies = OtpTransitServiceImpl.immutableList(builder.getAgenciesById().values());
        this.feedInfos = OtpTransitServiceImpl.immutableList(builder.getFeedInfos());
        this.siteRepository = builder.siteRepository().build();
        this.noticeAssignments = ImmutableListMultimap.copyOf(builder.getNoticeAssignments());
        this.operators = OtpTransitServiceImpl.immutableList(builder.getOperatorsById().values());
        this.pathways = OtpTransitServiceImpl.immutableList(builder.getPathways());
        this.serviceIds = OtpTransitServiceImpl.immutableList(builder.findAllServiceIds());
        this.entrancesById = builder.getEntrances().asImmutableMap();
        this.pathwayNodesById = builder.getPathwayNodes().asImmutableMap();
        this.boardingAreasById = builder.getBoardingAreas().asImmutableMap();
        this.transfers = OtpTransitServiceImpl.immutableList(builder.getTransfers());
        this.tripPatterns = OtpTransitServiceImpl.immutableList(builder.getTripPatterns().values());
        this.trips = OtpTransitServiceImpl.immutableList(builder.getTripsById().values());
        this.flexTrips = OtpTransitServiceImpl.immutableList(builder.getFlexTripsById().values());
        this.stopsByScheduledStopPoint = Collections.unmodifiableMap(builder.stopsByScheduledStopPoints());
    }

    @Override
    public Collection<Agency> getAllAgencies() {
        return this.agencies;
    }

    @Override
    public Collection<Operator> getAllOperators() {
        return this.operators;
    }

    @Override
    public Collection<FeedInfo> getAllFeedInfos() {
        return this.feedInfos;
    }

    @Override
    public SiteRepository siteRepository() {
        return this.siteRepository;
    }

    @Override
    public Multimap<AbstractTransitEntity, Notice> getNoticeAssignments() {
        return this.noticeAssignments;
    }

    @Override
    public Collection<Pathway> getAllPathways() {
        return this.pathways;
    }

    @Override
    public Collection<FeedScopedId> getAllServiceIds() {
        return this.serviceIds;
    }

    @Override
    public Collection<Entrance> getAllEntrances() {
        return OtpTransitServiceImpl.immutableList(this.entrancesById.values());
    }

    @Override
    public Collection<PathwayNode> getAllPathwayNodes() {
        return OtpTransitServiceImpl.immutableList(this.pathwayNodesById.values());
    }

    @Override
    public Collection<BoardingArea> getAllBoardingAreas() {
        return OtpTransitServiceImpl.immutableList(this.boardingAreasById.values());
    }

    @Override
    public Collection<ConstrainedTransfer> getAllTransfers() {
        return this.transfers;
    }

    @Override
    public Collection<TripPattern> getTripPatterns() {
        return this.tripPatterns;
    }

    @Override
    public Collection<Trip> getAllTrips() {
        return this.trips;
    }

    @Override
    public Collection<FlexTrip<?, ?>> getAllFlexTrips() {
        return this.flexTrips;
    }

    @Override
    public boolean hasActiveTransit() {
        return this.serviceIds.size() > 0;
    }

    @Override
    public Map<FeedScopedId, RegularStop> stopsByScheduledStopPoint() {
        return this.stopsByScheduledStopPoint;
    }

    private static <T> List<T> immutableList(Collection<T> c) {
        ArrayList<T> list = c instanceof List ? (ArrayList<T>)c : new ArrayList<T>(c);
        return Collections.unmodifiableList(list);
    }
}

