/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.StaySeatedNotAllowed;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.Frequency;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceCalendar;
import org.opentripplanner.model.calendar.ServiceCalendarDate;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.calendar.impl.CalendarServiceDataFactoryImpl;
import org.opentripplanner.model.impl.OtpTransitServiceImpl;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.routing.api.request.framework.TimePenalty;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.DefaultEntityById;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.ImmutableEntityById;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Branding;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.BoardingArea;
import org.opentripplanner.transit.model.site.Entrance;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.Pathway;
import org.opentripplanner.transit.model.site.PathwayNode;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.SiteRepository;
import org.opentripplanner.transit.service.SiteRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpTransitServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OtpTransitServiceBuilder.class);
    private final EntityById<Agency> agenciesById = new DefaultEntityById<Agency>();
    private final List<ServiceCalendarDate> calendarDates = new ArrayList<ServiceCalendarDate>();
    private final List<ServiceCalendar> calendars = new ArrayList<ServiceCalendar>();
    private final List<FeedInfo> feedInfos = new ArrayList<FeedInfo>();
    private final List<Frequency> frequencies = new ArrayList<Frequency>();
    private final SiteRepositoryBuilder siteRepositoryBuilder;
    private final Multimap<AbstractTransitEntity, Notice> noticeAssignments = ArrayListMultimap.create();
    private final EntityById<Operator> operatorsById = new DefaultEntityById<Operator>();
    private final List<Pathway> pathways = new ArrayList<Pathway>();
    private final EntityById<Route> routesById = new DefaultEntityById<Route>();
    private final Map<FeedScopedId, Iterable<ShapePoint>> shapePoints = new HashMap<FeedScopedId, Iterable<ShapePoint>>();
    private final EntityById<Entrance> entrancesById = new DefaultEntityById<Entrance>();
    private final EntityById<PathwayNode> pathwayNodesById = new DefaultEntityById<PathwayNode>();
    private final EntityById<BoardingArea> boardingAreasById = new DefaultEntityById<BoardingArea>();
    private final TripStopTimes stopTimesByTrip = new TripStopTimes();
    private final Map<Trip, TimePenalty> flexTimePenalties = new HashMap<Trip, TimePenalty>();
    private final EntityById<FareZone> fareZonesById = new DefaultEntityById<FareZone>();
    private final List<ConstrainedTransfer> transfers = new ArrayList<ConstrainedTransfer>();
    private final List<StaySeatedNotAllowed> staySeatedNotAllowed = new ArrayList<StaySeatedNotAllowed>();
    private final EntityById<Trip> tripsById = new DefaultEntityById<Trip>();
    private final Multimap<StopPattern, TripPattern> tripPatterns = ArrayListMultimap.create();
    private final EntityById<FlexTrip<?, ?>> flexTripsById = new DefaultEntityById();
    private final EntityById<Branding> brandingsById = new DefaultEntityById<Branding>();
    private final Multimap<FeedScopedId, GroupOfRoutes> groupsOfRoutesByRouteId = ArrayListMultimap.create();
    private final EntityById<TripOnServiceDate> tripOnServiceDates = new DefaultEntityById<TripOnServiceDate>();
    private final EntityById<GroupOfRoutes> groupOfRouteById = new DefaultEntityById<GroupOfRoutes>();
    private final List<VehicleParking> vehicleParkings = new ArrayList<VehicleParking>();
    private final Map<FeedScopedId, RegularStop> stopsByScheduledStopPoints = new HashMap<FeedScopedId, RegularStop>();
    private final DataImportIssueStore issueStore;

    public OtpTransitServiceBuilder(SiteRepository siteRepository, DataImportIssueStore issueStore) {
        this.siteRepositoryBuilder = siteRepository.withContext();
        this.issueStore = issueStore;
    }

    public EntityById<Agency> getAgenciesById() {
        return this.agenciesById;
    }

    public List<ServiceCalendarDate> getCalendarDates() {
        return this.calendarDates;
    }

    public List<ServiceCalendar> getCalendars() {
        return this.calendars;
    }

    public List<FeedInfo> getFeedInfos() {
        return this.feedInfos;
    }

    public List<Frequency> getFrequencies() {
        return this.frequencies;
    }

    public SiteRepositoryBuilder siteRepository() {
        return this.siteRepositoryBuilder;
    }

    public ImmutableEntityById<MultiModalStation> getMultiModalStationsById() {
        return this.siteRepositoryBuilder.multiModalStationById();
    }

    public Multimap<AbstractTransitEntity, Notice> getNoticeAssignments() {
        return this.noticeAssignments;
    }

    public EntityById<Operator> getOperatorsById() {
        return this.operatorsById;
    }

    public List<Pathway> getPathways() {
        return this.pathways;
    }

    public EntityById<Route> getRoutes() {
        return this.routesById;
    }

    public Map<FeedScopedId, Iterable<ShapePoint>> getShapePoints() {
        return this.shapePoints;
    }

    public ImmutableEntityById<Station> getStations() {
        return this.siteRepositoryBuilder.stationById();
    }

    public ImmutableEntityById<RegularStop> getStops() {
        return this.siteRepositoryBuilder.regularStopsById();
    }

    public EntityById<Entrance> getEntrances() {
        return this.entrancesById;
    }

    public EntityById<PathwayNode> getPathwayNodes() {
        return this.pathwayNodesById;
    }

    public EntityById<BoardingArea> getBoardingAreas() {
        return this.boardingAreasById;
    }

    public ImmutableEntityById<AreaStop> getAreaStops() {
        return this.siteRepositoryBuilder.areaStopById();
    }

    public TripStopTimes getStopTimesSortedByTrip() {
        return this.stopTimesByTrip;
    }

    public Map<Trip, TimePenalty> getFlexTimePenalty() {
        return this.flexTimePenalties;
    }

    public EntityById<FareZone> getFareZonesById() {
        return this.fareZonesById;
    }

    public List<ConstrainedTransfer> getTransfers() {
        return this.transfers;
    }

    public List<StaySeatedNotAllowed> getStaySeatedNotAllowed() {
        return this.staySeatedNotAllowed;
    }

    public EntityById<Trip> getTripsById() {
        return this.tripsById;
    }

    public Multimap<StopPattern, TripPattern> getTripPatterns() {
        return this.tripPatterns;
    }

    public EntityById<FlexTrip<?, ?>> getFlexTripsById() {
        return this.flexTripsById;
    }

    public EntityById<Branding> getBrandingsById() {
        return this.brandingsById;
    }

    public Multimap<FeedScopedId, GroupOfRoutes> getGroupsOfRoutesByRouteId() {
        return this.groupsOfRoutesByRouteId;
    }

    public EntityById<GroupOfRoutes> getGroupOfRouteById() {
        return this.groupOfRouteById;
    }

    public EntityById<TripOnServiceDate> getTripOnServiceDates() {
        return this.tripOnServiceDates;
    }

    public CalendarServiceData buildCalendarServiceData() {
        return CalendarServiceDataFactoryImpl.createCalendarServiceData(this.getCalendarDates(), this.getCalendars());
    }

    public List<VehicleParking> vehicleParkings() {
        return this.vehicleParkings;
    }

    public Map<FeedScopedId, RegularStop> stopsByScheduledStopPoints() {
        return this.stopsByScheduledStopPoints;
    }

    public OtpTransitService build() {
        return new OtpTransitServiceImpl(this);
    }

    public void limitServiceDays(ServiceDateInterval periodLimit) {
        if (periodLimit.isUnbounded()) {
            LOG.info("Limiting transit service is skipped, the period is unbounded.");
            return;
        }
        LOG.warn("Limiting transit service days to time period: {}", (Object)periodLimit);
        int orgSize = this.calendarDates.size();
        this.calendarDates.removeIf(c -> !periodLimit.include(c.getDate()));
        OtpTransitServiceBuilder.logRemove("ServiceCalendarDate", orgSize, this.calendarDates.size(), "Outside time period.");
        ArrayList<ServiceCalendar> keepCal = new ArrayList<ServiceCalendar>();
        for (ServiceCalendar calendar : this.calendars) {
            if (!calendar.getPeriod().overlap(periodLimit)) continue;
            calendar.setPeriod(calendar.getPeriod().intersection(periodLimit));
            keepCal.add(calendar);
        }
        orgSize = this.calendars.size();
        if (orgSize != keepCal.size()) {
            this.calendars.clear();
            this.calendars.addAll(keepCal);
            OtpTransitServiceBuilder.logRemove("ServiceCalendar", orgSize, this.calendars.size(), "Outside time period.");
        }
        this.removeEntitiesWithInvalidReferences();
        LOG.info("Limiting transit service days to time period complete.");
    }

    public void addStopByScheduledStopPoint(FeedScopedId sspid, RegularStop stop) {
        this.stopsByScheduledStopPoints.put(sspid, stop);
    }

    Set<FeedScopedId> findAllServiceIds() {
        HashSet<FeedScopedId> serviceIds = new HashSet<FeedScopedId>();
        for (ServiceCalendar calendar : this.getCalendars()) {
            serviceIds.add(calendar.getServiceId());
        }
        for (ServiceCalendarDate date : this.getCalendarDates()) {
            serviceIds.add(date.getServiceId());
        }
        return serviceIds;
    }

    private static void logRemove(String type, int orgSize, int newSize, String reason) {
        if (orgSize == newSize) {
            return;
        }
        LOG.info("{} of {} {}(s) removed. Reason: {}", new Object[]{orgSize - newSize, orgSize, type, reason});
    }

    private void removeEntitiesWithInvalidReferences() {
        this.removeTripsWithNoneExistingServiceIds();
        this.removeStopTimesForNoneExistingTrips();
        this.fixOrRemovePatternsWhichReferenceNoneExistingTrips();
        this.removeTransfersForNoneExistingTrips();
        this.removeTripOnServiceDateForNonExistingTrip();
    }

    private void removeTripsWithNoneExistingServiceIds() {
        Set<FeedScopedId> serviceIds = this.findAllServiceIds();
        int orgSize = this.tripsById.size();
        this.tripsById.removeIf(t -> !serviceIds.contains(t.getServiceId()), t -> this.issueStore.add("RemovedMissingServiceIdTrip", "Removed trip %s as service id %s does not exist", t.getId(), t.getServiceId()));
        OtpTransitServiceBuilder.logRemove("Trip", orgSize, this.tripsById.size(), "Trip service id does not exist.");
    }

    private void removeStopTimesForNoneExistingTrips() {
        int orgSize = this.stopTimesByTrip.size();
        this.stopTimesByTrip.removeIf(t -> !this.tripsById.containsKey(t.getId()));
        OtpTransitServiceBuilder.logRemove("StopTime", orgSize, this.stopTimesByTrip.size(), "StopTime trip does not exist.");
    }

    private void fixOrRemovePatternsWhichReferenceNoneExistingTrips() {
        int orgSize = this.tripPatterns.size();
        ArrayList<Map.Entry> removePatterns = new ArrayList<Map.Entry>();
        ArrayList<TripPattern> updatedPatterns = new ArrayList<TripPattern>();
        for (Map.Entry e : this.tripPatterns.entries()) {
            TripPattern ptn = (TripPattern)e.getValue();
            Set<TripTimes> tripTimesToBeRemoved = ptn.getScheduledTimetable().getTripTimes().stream().filter(tripTimes -> !this.tripsById.containsKey(tripTimes.getTrip().getId())).collect(Collectors.toUnmodifiableSet());
            if (tripTimesToBeRemoved.isEmpty()) continue;
            removePatterns.add(e);
            Timetable updatedTimetable = ptn.getScheduledTimetable().copyOf().removeAllTripTimes(tripTimesToBeRemoved).build();
            TripPattern updatedPattern = (TripPattern)ptn.copy().withScheduledTimeTable(updatedTimetable).build();
            if (!updatedTimetable.getTripTimes().isEmpty()) {
                updatedPatterns.add(updatedPattern);
                continue;
            }
            this.issueStore.add("RemovedEmptyTripPattern", "Removed trip pattern %s as it contains no trips", updatedPattern.getId());
        }
        for (Map.Entry it : removePatterns) {
            this.tripPatterns.remove(it.getKey(), it.getValue());
        }
        for (TripPattern tripPattern : updatedPatterns) {
            this.tripPatterns.put((Object)tripPattern.getStopPattern(), (Object)tripPattern);
        }
        OtpTransitServiceBuilder.logRemove("TripPattern", orgSize, this.tripPatterns.size(), "No trips for pattern exist.");
    }

    private void removeTransfersForNoneExistingTrips() {
        int orgSize = this.transfers.size();
        this.transfers.removeIf(this::transferTripReferencesDoNotExist);
        OtpTransitServiceBuilder.logRemove("Trip", orgSize, this.transfers.size(), "Transfer to/from trip does not exist.");
    }

    private void removeTripOnServiceDateForNonExistingTrip() {
        int orgSize = this.tripOnServiceDates.size();
        for (TripOnServiceDate tripOnServiceDate : this.tripOnServiceDates.values()) {
            if (this.tripsById.containsKey(tripOnServiceDate.getTrip().getId())) continue;
            OtpTransitServiceBuilder.logRemove("TripOnServiceDate", orgSize, this.tripOnServiceDates.size(), "Trip for TripOnServiceDate does not exist.");
        }
    }

    private boolean transferTripReferencesDoNotExist(ConstrainedTransfer t) {
        return this.transferPointTripReferenceDoesNotExist(t.getFrom()) || this.transferPointTripReferenceDoesNotExist(t.getTo());
    }

    private boolean transferPointTripReferenceDoesNotExist(TransferPoint point) {
        if (!point.isTripTransferPoint()) {
            return false;
        }
        Trip trip = point.asTripTransferPoint().getTrip();
        return !this.tripsById.containsKey(trip.getId());
    }
}

