/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.fare;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class ItineraryFare {
    private final Set<FareProduct> itineraryProducts = new LinkedHashSet<FareProduct>();
    private final Multimap<Leg, FareOffer> legProducts = LinkedHashMultimap.create();

    public static ItineraryFare empty() {
        return new ItineraryFare();
    }

    public List<FareProduct> getItineraryProducts() {
        return List.copyOf(this.itineraryProducts);
    }

    public Multimap<Leg, FareOffer> getLegProducts() {
        return ImmutableMultimap.copyOf(this.legProducts);
    }

    public void addItineraryProducts(Collection<FareProduct> products) {
        this.itineraryProducts.addAll(products);
    }

    public int hashCode() {
        return Objects.hash(this.itineraryProducts, this.legProducts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItineraryFare fare1 = (ItineraryFare)o;
        return Objects.equals(this.itineraryProducts, fare1.itineraryProducts) && Objects.equals(this.legProducts, fare1.legProducts);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("itineraryProducts", this.itineraryProducts).addObj("legProducts", this.legProducts).toString();
    }

    public void addFareProduct(Leg leg, FareOffer offer) {
        this.legProducts.put((Object)leg, (Object)offer);
    }

    public void addFareProductUses(Multimap<Leg, FareOffer> fareProducts) {
        this.legProducts.putAll(fareProducts);
    }

    public void add(ItineraryFare fare) {
        this.itineraryProducts.addAll(fare.itineraryProducts);
        this.legProducts.putAll(fare.legProducts);
    }

    public boolean isEmpty() {
        return this.itineraryProducts.isEmpty() && this.legProducts.isEmpty();
    }
}

