/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.fare;

import java.time.Duration;
import org.opentripplanner.model.fare.FareMedium;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.model.fare.RiderCategory;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class FareProductBuilder {
    private final FeedScopedId id;
    private final String name;
    private final Money price;
    private Duration validity;
    private RiderCategory category;
    private FareMedium medium;

    public FareProductBuilder(FeedScopedId id, String name, Money price) {
        this.id = id;
        this.name = name;
        this.price = price;
    }

    public FeedScopedId id() {
        return this.id;
    }

    public FareProductBuilder withValidity(Duration validity) {
        this.validity = validity;
        return this;
    }

    public FareProductBuilder withCategory(RiderCategory category) {
        this.category = category;
        return this;
    }

    public FareProductBuilder withMedium(FareMedium medium) {
        this.medium = medium;
        return this;
    }

    public String name() {
        return this.name;
    }

    public Money price() {
        return this.price;
    }

    public Duration validity() {
        return this.validity;
    }

    public RiderCategory category() {
        return this.category;
    }

    public FareMedium medium() {
        return this.medium;
    }

    public FareProduct build() {
        return new FareProduct(this);
    }
}

