/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.fare;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.opentripplanner.model.fare.FareMedium;
import org.opentripplanner.model.fare.FareProductBuilder;
import org.opentripplanner.model.fare.RiderCategory;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class FareProduct
implements Serializable {
    private final FeedScopedId id;
    private final String name;
    private final Money price;
    @Nullable
    private final RiderCategory category;
    @Nullable
    private final FareMedium medium;

    FareProduct(FareProductBuilder builder) {
        this.id = Objects.requireNonNull(builder.id());
        this.name = Objects.requireNonNull(builder.name());
        this.price = Objects.requireNonNull(builder.price());
        this.category = builder.category();
        this.medium = builder.medium();
    }

    public static FareProductBuilder of(FeedScopedId id, String name, Money price) {
        return new FareProductBuilder(id, name, price);
    }

    public String toString() {
        return ToStringBuilder.of(FareProduct.class).addStr("id", this.id.toString()).addStr("name", this.name).addObj("amount", (Object)this.price).addObj("category", (Object)this.category).addObj("medium", (Object)this.medium).toString();
    }

    public String uniqueInstanceId(ZonedDateTime startTime) {
        StringBuilder buf = new StringBuilder();
        buf.append(startTime.toEpochSecond()).append(this.id).append(this.price.currency().getCurrencyCode()).append(this.price.minorUnitAmount());
        if (this.medium != null) {
            buf.append(this.medium.id()).append(this.medium.name());
        }
        if (this.category != null) {
            buf.append(this.category.id()).append(this.category.name());
        }
        return UUID.nameUUIDFromBytes(buf.toString().getBytes(StandardCharsets.UTF_8)).toString();
    }

    public FeedScopedId id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Money price() {
        return this.price;
    }

    public boolean isFree() {
        return this.price.isZero();
    }

    @Nullable
    public RiderCategory category() {
        return this.category;
    }

    @Nullable
    public FareMedium medium() {
        return this.medium;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FareProduct that = (FareProduct)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.price, that.price) && Objects.equals(this.category, that.category) && Objects.equals(this.medium, that.medium);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.price, this.category, this.medium);
    }
}

