/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.fare;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.fare.FareProduct;

public sealed interface FareOffer {
    public static FareOffer of(ZonedDateTime startTime, FareProduct product, Collection<FareProduct> dependencies) {
        if (dependencies.isEmpty()) {
            return FareOffer.of(startTime, product);
        }
        return new DependentFareOffer(startTime, product, dependencies.stream().map(fp -> FareOffer.of(startTime, fp)).collect(Collectors.toSet()));
    }

    public static FareOffer of(ZonedDateTime startTime, FareProduct product) {
        return new DefaultFareOffer(startTime, product);
    }

    public String uniqueId();

    public FareProduct fareProduct();

    public ZonedDateTime startTime();

    public record DependentFareOffer(ZonedDateTime startTime, FareProduct fareProduct, Set<FareOffer> dependencies) implements FareOffer
    {
        public DependentFareOffer {
            Objects.requireNonNull(fareProduct);
            Objects.requireNonNull(dependencies);
            if (dependencies.isEmpty()) {
                throw new IllegalArgumentException("Dependencies must not be empty");
            }
        }

        public Collection<FareOffer> dependenciesMatchingCategoryAndMedium() {
            return this.dependencies.stream().filter(fp -> Objects.equals(fp.fareProduct().category(), this.fareProduct.category()) && Objects.equals(fp.fareProduct().medium(), this.fareProduct.medium())).toList();
        }

        @Override
        public String uniqueId() {
            return this.fareProduct().uniqueInstanceId(this.startTime);
        }
    }

    public record DefaultFareOffer(ZonedDateTime startTime, FareProduct fareProduct) implements FareOffer
    {
        @Override
        public String uniqueId() {
            return this.fareProduct().uniqueInstanceId(this.startTime);
        }
    }
}

