/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.openinghours;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.stream.Collectors;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;
import org.opentripplanner.model.calendar.openinghours.OpeningHours;
import org.opentripplanner.utils.time.TimeUtils;

public class OsmOpeningHoursSupport {
    public static String osmFormat(OHCalendar calendar) {
        return calendar.openingHours().stream().map(OsmOpeningHoursSupport::osmFormat).collect(Collectors.joining("; "));
    }

    public static String osmFormat(OpeningHours oh) {
        return OsmOpeningHoursSupport.toOsm(oh.periodDescription()) + " " + TimeUtils.timeToStrCompact((int)OsmOpeningHoursSupport.truncateToMinute(oh.startTime())) + "-" + TimeUtils.timeToStrCompact((int)OsmOpeningHoursSupport.truncateToMinute(oh.endTime()));
    }

    private static int truncateToMinute(long startTime) {
        return (int)Duration.ofSeconds(startTime).truncatedTo(ChronoUnit.MINUTES).toSeconds();
    }

    private static String toOsm(String description) {
        return switch (description.toLowerCase()) {
            case "business days" -> "Mo-Fr";
            case "monday" -> "Mo";
            case "tuesday" -> "Tu";
            case "wednesday" -> "We";
            case "thursday" -> "Th";
            case "friday" -> "Fr";
            case "saturday" -> "Sa";
            case "sunday" -> "Su";
            case "every day" -> "Mo-Su";
            default -> description;
        };
    }
}

