/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.openinghours;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Objects;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.calendar.openinghours.OHCalendarBuilder;
import org.opentripplanner.standalone.config.api.TransitServicePeriod;
import org.opentripplanner.transit.model.framework.Deduplicator;

public class OpeningHoursCalendarService
implements Serializable {
    private final Deduplicator deduplicator;
    private final LocalDate startOfPeriod;
    private final int daysInPeriod;

    @Inject
    public OpeningHoursCalendarService(Deduplicator deduplicator, @TransitServicePeriod ServiceDateInterval transitServicePeriod) {
        this.deduplicator = deduplicator;
        this.startOfPeriod = transitServicePeriod.getStart();
        this.daysInPeriod = transitServicePeriod.daysInPeriod();
    }

    public OpeningHoursCalendarService(Deduplicator deduplicator, LocalDate startOfPeriod, LocalDate endOfPeriod) {
        this(deduplicator, new ServiceDateInterval(startOfPeriod, endOfPeriod));
    }

    public OHCalendarBuilder newBuilder(ZoneId zoneId) {
        return new OHCalendarBuilder(this.deduplicator, this.startOfPeriod, this.daysInPeriod, zoneId);
    }

    public int hashCode() {
        return Objects.hash(this.deduplicator, this.startOfPeriod, this.daysInPeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpeningHoursCalendarService that = (OpeningHoursCalendarService)o;
        return this.deduplicator.equals(that.deduplicator) && this.startOfPeriod.equals(that.startOfPeriod) && this.daysInPeriod == that.daysInPeriod;
    }
}

