/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.openinghours;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.model.calendar.openinghours.OpeningHours;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class OHCalendar
implements Serializable {
    private final ZoneId zoneId;
    private final List<OpeningHours> openingHours;
    private final LocalDate startOfCalendar;
    private final LocalDate endOfCalendar;

    public OHCalendar(LocalDate startOfCalendar, LocalDate endOfCalendar, ZoneId zoneId, List<OpeningHours> openingHours) {
        this.startOfCalendar = startOfCalendar;
        this.endOfCalendar = endOfCalendar;
        this.zoneId = zoneId;
        this.openingHours = openingHours;
    }

    public boolean isOpen(long timeEpochSecond) {
        ZonedDateTime searchDateTime = Instant.ofEpochSecond(timeEpochSecond).atZone(this.zoneId);
        LocalDate searchDate = searchDateTime.toLocalDate();
        int daysFromStart = (int)ChronoUnit.DAYS.between(this.startOfCalendar, searchDate);
        int daysUntilEnd = (int)ChronoUnit.DAYS.between(searchDate, this.endOfCalendar);
        if (daysFromStart < 0 || daysUntilEnd < 0) {
            return false;
        }
        int secondsFromMidnight = searchDateTime.toLocalTime().toSecondOfDay();
        return this.openingHours.stream().anyMatch(openingHoursDefinition -> openingHoursDefinition.isOpen(daysFromStart, secondsFromMidnight));
    }

    public int hashCode() {
        return Objects.hash(this.zoneId, this.openingHours, this.startOfCalendar, this.endOfCalendar);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OHCalendar that = (OHCalendar)o;
        return this.openingHours.equals(that.openingHours) && this.zoneId.equals(that.zoneId) && this.startOfCalendar.equals(that.startOfCalendar) && this.endOfCalendar.equals(that.endOfCalendar);
    }

    public String toString() {
        return ToStringBuilder.of(OHCalendar.class).addObj("zoneId", (Object)this.zoneId).addCol("openingHours", this.openingHours).toString();
    }

    public List<OpeningHours> openingHours() {
        return this.openingHours;
    }
}

