/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.impl;

import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class CalendarServiceImpl
implements CalendarService {
    private final CalendarServiceData data;

    public CalendarServiceImpl(CalendarServiceData data) {
        this.data = data;
    }

    @Override
    public Set<FeedScopedId> getServiceIds() {
        return this.data.getServiceIds();
    }

    @Override
    public Set<LocalDate> getServiceDatesForServiceId(FeedScopedId serviceId) {
        HashSet<LocalDate> dates = new HashSet<LocalDate>();
        List<LocalDate> serviceDates = this.data.getServiceDatesForServiceId(serviceId);
        if (serviceDates != null) {
            dates.addAll(serviceDates);
        }
        return dates;
    }

    @Override
    public Set<FeedScopedId> getServiceIdsOnDate(LocalDate date) {
        return this.data.getServiceIdsForDate(date);
    }

    public FeedScopedId getOrCreateServiceIdForDate(LocalDate serviceDate) {
        return this.data.getOrCreateServiceIdForDate(serviceDate);
    }
}

