/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.opentripplanner.utils.time.ServiceDateUtils;

public final class ServiceDateInterval {
    private static final ServiceDateInterval UNBOUNDED = new ServiceDateInterval(LocalDate.MIN, LocalDate.MAX);
    private final LocalDate start;
    private final LocalDate end;

    public ServiceDateInterval(LocalDate start, LocalDate end) {
        this.start = start == null ? LocalDate.MIN : start;
        LocalDate localDate = this.end = end == null ? LocalDate.MAX : end;
        if (this.end.isBefore(this.start)) {
            throw new IllegalArgumentException("Invalid interval, the end " + String.valueOf(end) + " is before the start " + String.valueOf(start));
        }
    }

    public static ServiceDateInterval unbounded() {
        return UNBOUNDED;
    }

    public boolean isUnbounded() {
        return this.start.equals(LocalDate.MIN) && this.end.equals(LocalDate.MAX);
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public boolean overlap(ServiceDateInterval other) {
        if (!this.start.isAfter(other.end)) {
            return !this.end.isBefore(other.start);
        }
        return false;
    }

    public ServiceDateInterval intersection(ServiceDateInterval other) {
        return new ServiceDateInterval(ServiceDateUtils.max((LocalDate)this.start, (LocalDate)other.start), ServiceDateUtils.min((LocalDate)this.end, (LocalDate)other.end));
    }

    public boolean include(LocalDate date) {
        return !this.start.isAfter(date) && !this.end.isBefore(date);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDateInterval that = (ServiceDateInterval)o;
        return this.start.equals(that.start) && this.end.equals(that.end);
    }

    public String toString() {
        return "[" + ServiceDateUtils.toString((LocalDate)this.start) + ", " + ServiceDateUtils.toString((LocalDate)this.end) + "]";
    }

    public int daysInPeriod() {
        return (int)ChronoUnit.DAYS.between(this.start, this.end) + 1;
    }
}

