/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.StopTimeKey;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.utils.lang.IntUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripTimeOnDate {
    private static final Logger LOG = LoggerFactory.getLogger(TripTimeOnDate.class);
    public static final int UNDEFINED = -1;
    private final TripTimes tripTimes;
    private final int stopIndex;
    private final TripPattern tripPattern;
    @Nullable
    private final LocalDate serviceDate;
    private final long midnight;

    public TripTimeOnDate(TripTimes tripTimes, int stopIndex, TripPattern tripPattern) {
        this.tripTimes = tripTimes;
        this.stopIndex = stopIndex;
        this.tripPattern = tripPattern;
        this.serviceDate = null;
        this.midnight = -1L;
    }

    public TripTimeOnDate(TripTimes tripTimes, int stopIndex, TripPattern tripPattern, @Nullable LocalDate serviceDate, @Nullable Instant midnight) {
        this.tripTimes = tripTimes;
        this.stopIndex = stopIndex;
        this.tripPattern = tripPattern;
        this.serviceDate = serviceDate;
        this.midnight = midnight != null ? midnight.getEpochSecond() : -1L;
    }

    @Nullable
    public static List<TripTimeOnDate> fromTripTimes(Timetable table, Trip trip) {
        TripTimes times = table.getTripTimes(trip);
        if (times == null) {
            return null;
        }
        ArrayList<TripTimeOnDate> out = new ArrayList<TripTimeOnDate>();
        for (int i = 0; i < times.getNumStops(); ++i) {
            out.add(new TripTimeOnDate(times, i, table.getPattern()));
        }
        return out;
    }

    public static List<TripTimeOnDate> fromTripTimesWithScheduleFallback(Timetable table, Trip trip, LocalDate serviceDate, Instant midnight) {
        TripTimes times = table.getTripTimes(trip);
        if (times == null) {
            Timetable scheduledTimetable = table.getPattern().getScheduledTimetable();
            return TripTimeOnDate.fromTripTimes(scheduledTimetable, trip);
        }
        ArrayList<TripTimeOnDate> out = new ArrayList<TripTimeOnDate>();
        for (int i = 0; i < times.getNumStops(); ++i) {
            out.add(new TripTimeOnDate(times, i, table.getPattern(), serviceDate, midnight));
        }
        return out;
    }

    public static List<TripTimeOnDate> fromTripTimes(Timetable table, Trip trip, LocalDate serviceDate, Instant midnight) {
        TripTimes times = Objects.requireNonNull(table.getTripTimes(trip));
        ArrayList<TripTimeOnDate> out = new ArrayList<TripTimeOnDate>();
        for (int i = 0; i < times.getNumStops(); ++i) {
            out.add(new TripTimeOnDate(times, i, table.getPattern(), serviceDate, midnight));
        }
        return out;
    }

    public static TripTimeOnDate firstFromTripTimes(Timetable table, Trip trip, LocalDate serviceDate, Instant midnight) {
        TripTimes times = table.getTripTimes(trip);
        return new TripTimeOnDate(times, 0, table.getPattern(), serviceDate, midnight);
    }

    public static TripTimeOnDate lastFromTripTimes(Timetable table, Trip trip, LocalDate serviceDate, Instant midnight) {
        TripTimes times = table.getTripTimes(trip);
        return new TripTimeOnDate(times, times.getNumStops() - 1, table.getPattern(), serviceDate, midnight);
    }

    public static Comparator<TripTimeOnDate> compareByDeparture() {
        return Comparator.comparing(t -> t.getServiceDayMidnight() + (long)t.getRealtimeDeparture());
    }

    public static Comparator<TripTimeOnDate> compareByScheduledDeparture() {
        return Comparator.comparing(t -> t.getServiceDayMidnight() + (long)t.getScheduledDeparture());
    }

    public StopLocation getStop() {
        return this.tripPattern.getStop(this.stopIndex);
    }

    public int getStopIndex() {
        return this.stopIndex;
    }

    public TripTimes getTripTimes() {
        return this.tripTimes;
    }

    public boolean hasScheduledTimes() {
        return this.tripTimes.getScheduledArrivalTime(this.stopIndex) != -999 && this.tripTimes.getScheduledDepartureTime(this.stopIndex) != -999;
    }

    public int getScheduledArrival() {
        return this.tripTimes.getScheduledArrivalTime(this.stopIndex);
    }

    public Instant scheduledArrival() {
        return this.toInstant(this.getScheduledArrival());
    }

    public int getGtfsSequence() {
        return this.tripTimes.gtfsSequenceOfStopIndex(this.stopIndex);
    }

    public int getScheduledDeparture() {
        return this.tripTimes.getScheduledDepartureTime(this.stopIndex);
    }

    public Instant scheduledDeparture() {
        return this.toInstant(this.getScheduledDeparture());
    }

    public int getRealtimeArrival() {
        return this.isCancelledStop() || this.isNoDataStop() ? this.tripTimes.getScheduledArrivalTime(this.stopIndex) : this.tripTimes.getArrivalTime(this.stopIndex);
    }

    public int getRealtimeDeparture() {
        return this.isCancelledStop() || this.isNoDataStop() ? this.tripTimes.getScheduledDepartureTime(this.stopIndex) : this.tripTimes.getDepartureTime(this.stopIndex);
    }

    public int getActualArrival() {
        return this.isRecordedStop() ? this.tripTimes.getArrivalTime(this.stopIndex) : -1;
    }

    public int getActualDeparture() {
        return this.isRecordedStop() ? this.tripTimes.getDepartureTime(this.stopIndex) : -1;
    }

    public int getArrivalDelay() {
        return this.isCancelledStop() || this.isNoDataStop() ? 0 : this.tripTimes.getArrivalDelay(this.stopIndex);
    }

    public int getDepartureDelay() {
        return this.isCancelledStop() || this.isNoDataStop() ? 0 : this.tripTimes.getDepartureDelay(this.stopIndex);
    }

    public boolean isTimepoint() {
        return this.tripTimes.isTimepoint(this.stopIndex);
    }

    public boolean isRealtime() {
        return !this.tripTimes.isScheduled() && !this.isNoDataStop();
    }

    public boolean isCancelledStop() {
        return this.tripTimes.isCancelledStop(this.stopIndex) || this.tripPattern.isBoardAndAlightAt(this.stopIndex, PickDrop.CANCELLED);
    }

    public boolean isPredictionInaccurate() {
        return this.tripTimes.isPredictionInaccurate(this.stopIndex);
    }

    public boolean isCanceledEffectively() {
        return this.isCancelledStop() || this.tripTimes.isCanceledOrDeleted() || this.tripTimes.getTrip().getNetexAlteration().isCanceledOrReplaced();
    }

    public boolean isNoDataStop() {
        return this.tripTimes.isNoDataStop(this.stopIndex);
    }

    public boolean isRecordedStop() {
        return this.tripTimes.isRecordedStop(this.stopIndex);
    }

    public RealTimeState getRealTimeState() {
        return this.tripTimes.isNoDataStop(this.stopIndex) ? RealTimeState.SCHEDULED : this.tripTimes.getRealTimeState();
    }

    public OccupancyStatus getOccupancyStatus() {
        return this.tripTimes.getOccupancyStatus(this.stopIndex);
    }

    public long getServiceDayMidnight() {
        return this.midnight;
    }

    public LocalDate getServiceDay() {
        return this.serviceDate;
    }

    public Trip getTrip() {
        return this.tripTimes.getTrip();
    }

    public I18NString getHeadsign() {
        return this.tripTimes.getHeadsign(this.stopIndex);
    }

    public List<String> getHeadsignVias() {
        return this.tripTimes.getHeadsignVias(this.stopIndex);
    }

    public PickDrop getPickupType() {
        if (this.tripTimes.isDeleted()) {
            LOG.warn("Returning pickup type for a deleted trip {} on pattern {} on date {}. This indicates a bug.", new Object[]{this.tripTimes.getTrip().getId(), this.tripPattern.getId(), this.serviceDate});
            return this.tripPattern.getBoardType(this.stopIndex);
        }
        return this.tripTimes.isCanceled() || this.tripTimes.isCancelledStop(this.stopIndex) ? PickDrop.CANCELLED : this.tripPattern.getBoardType(this.stopIndex);
    }

    public PickDrop getDropoffType() {
        if (this.tripTimes.isDeleted()) {
            LOG.warn("Returning dropoff type for a deleted trip {} on pattern {} on date {}. This indicates a bug.", new Object[]{this.tripTimes.getTrip().getId(), this.tripPattern.getId(), this.serviceDate});
            return this.tripPattern.getAlightType(this.stopIndex);
        }
        return this.tripTimes.isCanceled() || this.tripTimes.isCancelledStop(this.stopIndex) ? PickDrop.CANCELLED : this.tripPattern.getAlightType(this.stopIndex);
    }

    public StopTimeKey getStopTimeKey() {
        return (StopTimeKey)StopTimeKey.of(this.tripTimes.getTrip().getId(), this.stopIndex).build();
    }

    public BookingInfo getPickupBookingInfo() {
        return this.tripTimes.getPickupBookingInfo(this.stopIndex);
    }

    public BookingInfo getDropOffBookingInfo() {
        return this.tripTimes.getDropOffBookingInfo(this.stopIndex);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripTimeOnDate that = (TripTimeOnDate)o;
        return this.stopIndex == that.stopIndex && this.midnight == that.midnight && Objects.equals(this.tripTimes, that.tripTimes) && Objects.equals(this.tripPattern, that.tripPattern) && Objects.equals(this.serviceDate, that.serviceDate);
    }

    public int hashCode() {
        return Objects.hash(this.tripTimes, this.stopIndex, this.tripPattern, this.serviceDate, this.midnight);
    }

    public TripPattern pattern() {
        return this.tripPattern;
    }

    public List<TripTimeOnDate> previousTimes() {
        if (this.stopIndex == 0) {
            return List.of();
        }
        return IntStream.range(0, this.stopIndex).mapToObj(this::atStopIndex).toList();
    }

    public List<TripTimeOnDate> nextTimes() {
        if (this.stopIndex == this.tripTimes.getNumStops() - 1) {
            return List.of();
        }
        return IntStream.range(this.stopIndex + 1, this.tripTimes.getNumStops()).mapToObj(this::atStopIndex).toList();
    }

    public Optional<Instant> realtimeArrival() {
        return this.optionalInstant(this.getRealtimeArrival());
    }

    public Optional<Instant> realtimeDeparture() {
        return this.optionalInstant(this.getRealtimeDeparture());
    }

    private TripTimeOnDate atStopIndex(int stopIndex) {
        IntUtils.requireInRange((int)stopIndex, (int)0, (int)(this.tripTimes.getNumStops() - 1), (String)"stopIndex");
        return new TripTimeOnDate(this.tripTimes, stopIndex, this.tripPattern, this.serviceDate, Instant.ofEpochSecond(this.midnight));
    }

    private Optional<Instant> optionalInstant(int secondsSinceMidnight) {
        if (this.isCancelledStop() || this.isRealtime()) {
            return Optional.of(this.toInstant(secondsSinceMidnight));
        }
        return Optional.empty();
    }

    private Instant toInstant(int secondsSinceMidnight) {
        return Instant.ofEpochSecond(this.midnight).plusSeconds(secondsSinceMidnight);
    }

    public String toString() {
        return ToStringBuilder.of(TripTimeOnDate.class).addObj("trip", (Object)this.tripTimes.getTrip()).addNum("index", (Number)this.stopIndex).addServiceTime("arrival", this.getScheduledArrival()).addServiceTime("departure", this.getScheduledArrival()).addDate("serviceDate", this.serviceDate).toString();
    }
}

