/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.model.RealTimeTripUpdate;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableBuilder;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.RealTimeRaptorTransitDataUpdater;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.spi.UpdateSuccess;
import org.opentripplanner.utils.collection.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimetableSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(TimetableSnapshot.class);
    private final Map<TripPatternAndServiceDate, Timetable> dirtyTimetables = new HashMap<TripPatternAndServiceDate, Timetable>();
    private final Map<TripPattern, SortedSet<Timetable>> timetables;
    private final Map<TripIdAndServiceDate, TripPattern> realTimeNewTripPatternsForModifiedTrips;
    private final SetMultimap<StopLocation, TripPattern> patternsForStop;
    private final Map<FeedScopedId, Route> realtimeAddedRoutes;
    private final Map<FeedScopedId, Trip> realTimeAddedTrips;
    private final Map<Trip, TripPattern> realTimeAddedPatternForTrip;
    private final Multimap<Route, TripPattern> realTimeAddedPatternsForRoute;
    private final Map<FeedScopedId, TripOnServiceDate> realTimeAddedTripOnServiceDateById;
    private final Map<TripIdAndServiceDate, TripOnServiceDate> realTimeAddedTripOnServiceDateForTripAndDay;
    private final boolean readOnly;
    private boolean dirty = false;

    public TimetableSnapshot() {
        this(new HashMap<TripPattern, SortedSet<Timetable>>(), new HashMap<TripIdAndServiceDate, TripPattern>(), new HashMap<FeedScopedId, Route>(), new HashMap<FeedScopedId, Trip>(), new HashMap<Trip, TripPattern>(), (Multimap<Route, TripPattern>)HashMultimap.create(), new HashMap<FeedScopedId, TripOnServiceDate>(), new HashMap<TripIdAndServiceDate, TripOnServiceDate>(), (SetMultimap<StopLocation, TripPattern>)HashMultimap.create(), false);
    }

    private TimetableSnapshot(Map<TripPattern, SortedSet<Timetable>> timetables, Map<TripIdAndServiceDate, TripPattern> realTimeNewTripPatternsForModifiedTrips, Map<FeedScopedId, Route> realtimeAddedRoutes, Map<FeedScopedId, Trip> realtimeAddedTrips, Map<Trip, TripPattern> realTimeAddedPatternForTrip, Multimap<Route, TripPattern> realTimeAddedPatternsForRoute, Map<FeedScopedId, TripOnServiceDate> realTimeAddedTripOnServiceDateById, Map<TripIdAndServiceDate, TripOnServiceDate> realTimeAddedTripOnServiceDateForTripAndDay, SetMultimap<StopLocation, TripPattern> patternsForStop, boolean readOnly) {
        this.timetables = timetables;
        this.realTimeNewTripPatternsForModifiedTrips = realTimeNewTripPatternsForModifiedTrips;
        this.realtimeAddedRoutes = realtimeAddedRoutes;
        this.realTimeAddedTrips = realtimeAddedTrips;
        this.realTimeAddedPatternForTrip = realTimeAddedPatternForTrip;
        this.realTimeAddedPatternsForRoute = realTimeAddedPatternsForRoute;
        this.realTimeAddedTripOnServiceDateById = realTimeAddedTripOnServiceDateById;
        this.realTimeAddedTripOnServiceDateForTripAndDay = realTimeAddedTripOnServiceDateForTripAndDay;
        this.patternsForStop = patternsForStop;
        this.readOnly = readOnly;
    }

    public Timetable resolve(TripPattern pattern, @Nullable LocalDate serviceDate) {
        SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
        if (sortedTimetables != null && serviceDate != null) {
            for (Timetable timetable : sortedTimetables) {
                if (timetable == null || !timetable.isValidFor(serviceDate)) continue;
                return timetable;
            }
        }
        return pattern.getScheduledTimetable();
    }

    @Nullable
    public TripPattern getNewTripPatternForModifiedTrip(FeedScopedId tripId, LocalDate serviceDate) {
        TripIdAndServiceDate tripIdAndServiceDate = new TripIdAndServiceDate(tripId, serviceDate);
        return this.realTimeNewTripPatternsForModifiedTrips.get(tripIdAndServiceDate);
    }

    public List<TripOnServiceDate> listCanceledTrips() {
        return this.findTripsOnServiceDates(TripTimes::isCanceled);
    }

    public boolean hasNewTripPatternsForModifiedTrips() {
        return !this.realTimeNewTripPatternsForModifiedTrips.isEmpty();
    }

    @Nullable
    public Route getRealtimeAddedRoute(FeedScopedId id) {
        return (Route)CollectionUtils.getByNullableKey((Object)id, this.realtimeAddedRoutes);
    }

    public Collection<Route> listRealTimeAddedRoutes() {
        return Collections.unmodifiableCollection(this.realtimeAddedRoutes.values());
    }

    @Nullable
    public Trip getRealTimeAddedTrip(FeedScopedId id) {
        return (Trip)CollectionUtils.getByNullableKey((Object)id, this.realTimeAddedTrips);
    }

    public Collection<Trip> listRealTimeAddedTrips() {
        return Collections.unmodifiableCollection(this.realTimeAddedTrips.values());
    }

    @Nullable
    public TripPattern getRealTimeAddedPatternForTrip(Trip trip) {
        return (TripPattern)CollectionUtils.getByNullableKey((Object)trip, this.realTimeAddedPatternForTrip);
    }

    public Collection<TripPattern> getRealTimeAddedPatternForRoute(Route route) {
        return this.realTimeAddedPatternsForRoute.get((Object)route);
    }

    @Nullable
    public TripOnServiceDate getRealTimeAddedTripOnServiceDateById(FeedScopedId id) {
        return (TripOnServiceDate)CollectionUtils.getByNullableKey((Object)id, this.realTimeAddedTripOnServiceDateById);
    }

    @Nullable
    public TripOnServiceDate getRealTimeAddedTripOnServiceDateForTripAndDay(TripIdAndServiceDate tripIdAndServiceDate) {
        return (TripOnServiceDate)CollectionUtils.getByNullableKey((Object)tripIdAndServiceDate, this.realTimeAddedTripOnServiceDateForTripAndDay);
    }

    public Collection<? extends TripOnServiceDate> listRealTimeAddedTripOnServiceDate() {
        return Collections.unmodifiableCollection(this.realTimeAddedTripOnServiceDateForTripAndDay.values());
    }

    public Result<UpdateSuccess, UpdateError> update(RealTimeTripUpdate realTimeTripUpdate) {
        this.validateNotReadOnly();
        TripPattern pattern = realTimeTripUpdate.pattern();
        LocalDate serviceDate = realTimeTripUpdate.serviceDate();
        TripTimes updatedTripTimes = realTimeTripUpdate.updatedTripTimes();
        Timetable tt = this.resolve(pattern, serviceDate);
        TimetableBuilder ttb = tt.copyOf().withServiceDate(serviceDate);
        ttb.addOrUpdateTripTimes(updatedTripTimes);
        Timetable updated = ttb.build();
        this.swapTimetable(pattern, tt, updated);
        Trip trip = updatedTripTimes.getTrip();
        if (pattern.isCreatedByRealtimeUpdater()) {
            FeedScopedId tripId = trip.getId();
            TripIdAndServiceDate tripIdAndServiceDate = new TripIdAndServiceDate(tripId, serviceDate);
            this.realTimeNewTripPatternsForModifiedTrips.put(tripIdAndServiceDate, pattern);
        }
        this.addPatternToIndex(pattern);
        Route route = trip.getRoute();
        if (realTimeTripUpdate.routeCreation()) {
            this.realtimeAddedRoutes.put(route.getId(), route);
        }
        if (realTimeTripUpdate.tripCreation()) {
            FeedScopedId tripId = trip.getId();
            this.realTimeAddedTrips.put(tripId, trip);
            this.realTimeAddedPatternForTrip.put(trip, pattern);
            this.realTimeAddedPatternsForRoute.put((Object)route, (Object)pattern);
            TripOnServiceDate tripOnServiceDate = realTimeTripUpdate.addedTripOnServiceDate();
            if (tripOnServiceDate != null) {
                this.realTimeAddedTripOnServiceDateById.put(tripOnServiceDate.getId(), tripOnServiceDate);
                this.realTimeAddedTripOnServiceDateForTripAndDay.put(new TripIdAndServiceDate(tripId, serviceDate), tripOnServiceDate);
            }
        }
        return Result.success(UpdateSuccess.noWarnings(realTimeTripUpdate.producer()));
    }

    public TimetableSnapshot commit() {
        return this.commit(null, false);
    }

    public TimetableSnapshot commit(RealTimeRaptorTransitDataUpdater realtimeRaptorTransitDataUpdater, boolean force) {
        this.validateNotReadOnly();
        if (!force && !this.isDirty()) {
            return null;
        }
        TimetableSnapshot ret = new TimetableSnapshot(Map.copyOf(this.timetables), Map.copyOf(this.realTimeNewTripPatternsForModifiedTrips), Map.copyOf(this.realtimeAddedRoutes), Map.copyOf(this.realTimeAddedTrips), Map.copyOf(this.realTimeAddedPatternForTrip), (Multimap<Route, TripPattern>)ImmutableSetMultimap.copyOf(this.realTimeAddedPatternsForRoute), Map.copyOf(this.realTimeAddedTripOnServiceDateById), Map.copyOf(this.realTimeAddedTripOnServiceDateForTripAndDay), (SetMultimap<StopLocation, TripPattern>)ImmutableSetMultimap.copyOf(this.patternsForStop), true);
        if (realtimeRaptorTransitDataUpdater != null) {
            realtimeRaptorTransitDataUpdater.update(this.dirtyTimetables.values(), this.timetables);
        }
        this.dirtyTimetables.clear();
        this.dirty = false;
        return ret;
    }

    public void clear(String feedId) {
        this.validateNotReadOnly();
        boolean timetablesWereCleared = this.clearTimetables(feedId);
        boolean newTripPatternsForModifiedTripsWereCleared = this.clearNewTripPatternsForModifiedTrips(feedId);
        boolean addedTripPatternsWereCleared = this.clearEntriesForRealtimeAddedTrips(feedId);
        if (timetablesWereCleared || newTripPatternsForModifiedTripsWereCleared || addedTripPatternsWereCleared) {
            this.dirty = true;
        }
    }

    public boolean revertTripToScheduledTripPattern(FeedScopedId tripId, LocalDate serviceDate) {
        this.validateNotReadOnly();
        boolean success = false;
        TripPattern pattern = this.getNewTripPatternForModifiedTrip(tripId, serviceDate);
        if (pattern != null) {
            this.realTimeNewTripPatternsForModifiedTrips.remove(new TripIdAndServiceDate(tripId, serviceDate));
            SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
            if (sortedTimetables != null) {
                TripTimes tripTimesToRemove = null;
                for (Timetable timetable : sortedTimetables) {
                    if (!timetable.isValidFor(serviceDate)) continue;
                    TripTimes tripTimes = timetable.getTripTimes(tripId);
                    if (tripTimes == null) {
                        LOG.debug("No triptimes to remove for trip {}", (Object)tripId);
                        continue;
                    }
                    if (tripTimesToRemove != null) {
                        LOG.debug("Found two triptimes to remove for trip {}", (Object)tripId);
                        continue;
                    }
                    tripTimesToRemove = tripTimes;
                }
                if (tripTimesToRemove != null) {
                    for (Timetable originalTimetable : sortedTimetables) {
                        if (!originalTimetable.getTripTimes().contains(tripTimesToRemove)) continue;
                        Timetable updatedTimetable = originalTimetable.copyOf().removeTripTimes(tripTimesToRemove).build();
                        this.swapTimetable(pattern, originalTimetable, updatedTimetable);
                    }
                }
            }
            success = true;
        }
        return success;
    }

    public boolean purgeExpiredData(LocalDate serviceDate) {
        this.validateNotReadOnly();
        boolean modified = false;
        Iterator<TripPattern> it = this.timetables.keySet().iterator();
        while (it.hasNext()) {
            TripPattern pattern = it.next();
            SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
            TreeSet<Timetable> toKeepTimetables = new TreeSet<Timetable>(new SortedTimetableComparator());
            for (Timetable timetable : sortedTimetables) {
                if (serviceDate.isBefore(timetable.getServiceDate())) {
                    toKeepTimetables.add(timetable);
                    continue;
                }
                modified = true;
            }
            if (toKeepTimetables.isEmpty()) {
                it.remove();
                continue;
            }
            this.timetables.put(pattern, (SortedSet<Timetable>)ImmutableSortedSet.copyOfSorted(toKeepTimetables));
        }
        Iterator<Map.Entry<TripIdAndServiceDate, TripPattern>> iterator = this.realTimeNewTripPatternsForModifiedTrips.entrySet().iterator();
        while (iterator.hasNext()) {
            TripIdAndServiceDate tripIdAndServiceDate = iterator.next().getKey();
            if (serviceDate.isBefore(tripIdAndServiceDate.serviceDate())) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    public boolean isDirty() {
        if (this.readOnly) {
            return false;
        }
        return this.dirty;
    }

    public String toString() {
        String d = this.readOnly ? "committed" : String.format("%d dirty", this.dirtyTimetables.size());
        return String.format("Timetable snapshot: %d timetables (%s)", this.timetables.size(), d);
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop) {
        return this.patternsForStop.get((Object)stop);
    }

    public boolean isEmpty() {
        return this.dirtyTimetables.isEmpty() && this.timetables.isEmpty() && this.realTimeNewTripPatternsForModifiedTrips.isEmpty();
    }

    private boolean clearTimetables(String feedId) {
        return this.timetables.keySet().removeIf(tripPattern -> feedId.equals(tripPattern.getFeedId()));
    }

    private boolean clearNewTripPatternsForModifiedTrips(String feedId) {
        return this.realTimeNewTripPatternsForModifiedTrips.keySet().removeIf(tripIdAndServiceDate -> feedId.equals(tripIdAndServiceDate.tripId().getFeedId()));
    }

    private boolean clearEntriesForRealtimeAddedTrips(String feedId) {
        boolean removedEntry = this.realTimeAddedTrips.keySet().removeIf(id -> feedId.equals(id.getFeedId()));
        this.realTimeAddedPatternForTrip.keySet().removeIf(trip -> feedId.equals(trip.getId().getFeedId()));
        this.realTimeAddedTripOnServiceDateForTripAndDay.keySet().removeIf(tripOnServiceDate -> feedId.equals(tripOnServiceDate.tripId().getFeedId()));
        this.realTimeAddedTripOnServiceDateById.keySet().removeIf(id -> feedId.equals(id.getFeedId()));
        this.realTimeAddedPatternsForRoute.keySet().removeIf(route -> feedId.equals(route.getId().getFeedId()));
        this.realtimeAddedRoutes.keySet().removeIf(id -> feedId.equals(id.getFeedId()));
        return removedEntry;
    }

    private void addPatternToIndex(TripPattern tripPattern) {
        if (tripPattern.isCreatedByRealtimeUpdater()) {
            for (StopLocation stop : tripPattern.getStops()) {
                this.patternsForStop.put((Object)stop, (Object)tripPattern);
            }
        }
    }

    private void swapTimetable(TripPattern pattern, Timetable original, Timetable updated) {
        SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
        if (sortedTimetables == null) {
            sortedTimetables = new TreeSet<Timetable>(new SortedTimetableComparator());
        } else {
            TreeSet<Timetable> temp = new TreeSet<Timetable>(new SortedTimetableComparator());
            temp.addAll(sortedTimetables);
            sortedTimetables = temp;
        }
        if (original.isCreatedByRealTimeUpdater()) {
            sortedTimetables.remove(original);
        }
        sortedTimetables.add(updated);
        this.timetables.put(pattern, (SortedSet<Timetable>)ImmutableSortedSet.copyOfSorted(sortedTimetables));
        this.dirtyTimetables.put(new TripPatternAndServiceDate(pattern, updated.getServiceDate()), updated);
        this.dirty = true;
    }

    private void validateNotReadOnly() {
        if (this.readOnly) {
            throw new ConcurrentModificationException("This TimetableSnapshot is read-only.");
        }
    }

    private TripOnServiceDate mapToTripOnServiceDate(TripTimes tripTimes, Timetable timetable) {
        return (TripOnServiceDate)TripOnServiceDate.of(tripTimes.getTrip().getId()).withServiceDate(timetable.getServiceDate()).withTrip(tripTimes.getTrip()).build();
    }

    private List<TripOnServiceDate> findTripsOnServiceDates(Predicate<TripTimes> filter) {
        return this.timetables.values().stream().flatMap(timetables -> timetables.stream().flatMap(timetable -> timetable.getTripTimes().stream().filter(filter).map(tripTimes -> this.mapToTripOnServiceDate((TripTimes)tripTimes, (Timetable)timetable)))).collect(Collectors.toCollection(ArrayList::new));
    }

    protected static class SortedTimetableComparator
    implements Comparator<Timetable> {
        protected SortedTimetableComparator() {
        }

        @Override
        public int compare(Timetable t1, Timetable t2) {
            return t1.getServiceDate().compareTo(t2.getServiceDate());
        }
    }

    private record TripPatternAndServiceDate(TripPattern tripPattern, LocalDate serviceDate) {
    }
}

