/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimes;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;

public class TimetableBuilder {
    private TripPattern pattern;
    private LocalDate serviceDate;
    private final Map<FeedScopedId, TripTimes> tripTimes = new HashMap<FeedScopedId, TripTimes>();
    private final List<FrequencyEntry> frequencies = new ArrayList<FrequencyEntry>();

    TimetableBuilder() {
    }

    TimetableBuilder(Timetable tt) {
        this.pattern = tt.getPattern();
        this.serviceDate = tt.getServiceDate();
        this.frequencies.addAll(tt.getFrequencyEntries());
        this.addAllTripTimes(tt.getTripTimes());
    }

    public TimetableBuilder withTripPattern(TripPattern tripPattern) {
        this.pattern = tripPattern;
        return this;
    }

    public TimetableBuilder withServiceDate(LocalDate serviceDate) {
        this.serviceDate = serviceDate;
        return this;
    }

    public TimetableBuilder addTripTimes(TripTimes tripTimes) {
        Trip trip = tripTimes.getTrip();
        if (this.tripTimes.containsKey(trip.getId())) {
            throw new IllegalStateException("Error! TripTimes for the same trip is added twice. Trip: " + String.valueOf(trip));
        }
        return this.addOrUpdateTripTimes(tripTimes);
    }

    public TimetableBuilder addOrUpdateTripTimes(TripTimes tripTimes) {
        this.tripTimes.put(tripTimes.getTrip().getId(), tripTimes);
        return this;
    }

    public TimetableBuilder addAllTripTimes(List<TripTimes> tripTimes) {
        for (TripTimes it : tripTimes) {
            this.addTripTimes(it);
        }
        return this;
    }

    public TimetableBuilder removeTripTimes(TripTimes tripTimesToRemove) {
        this.tripTimes.remove(tripTimesToRemove.getTrip().getId());
        return this;
    }

    public TimetableBuilder removeAllTripTimes(Collection<TripTimes> tripTimesToBeRemoved) {
        for (TripTimes it : tripTimesToBeRemoved) {
            this.tripTimes.remove(it.getTrip().getId());
        }
        return this;
    }

    public TimetableBuilder updateAllTripTimes(UnaryOperator<TripTimes> update) {
        this.tripTimes.replaceAll((t, tt) -> (TripTimes)update.apply((TripTimes)tt));
        this.frequencies.replaceAll(it -> new FrequencyEntry(it.startTime, it.endTime, it.headway, it.exactTimes, (ScheduledTripTimes)update.apply(it.tripTimes)));
        return this;
    }

    public TimetableBuilder addFrequencyEntry(FrequencyEntry frequencyEntry) {
        this.frequencies.add(frequencyEntry);
        return this;
    }

    public Direction getDirection() {
        return Timetable.getDirection(this.tripTimes.values(), this.frequencies);
    }

    public Timetable build() {
        return new Timetable(this);
    }

    List<TripTimes> createImmutableOrderedListOfTripTimes() {
        return this.tripTimes.values().stream().sorted().toList();
    }

    TripPattern getPattern() {
        return this.pattern;
    }

    LocalDate getServiceDate() {
        return this.serviceDate;
    }

    List<FrequencyEntry> getFrequencies() {
        return this.frequencies;
    }
}

