/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opentripplanner.model.TimetableBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;

public class Timetable
implements Serializable {
    private final TripPattern pattern;
    private List<TripTimes> tripTimes;
    private List<FrequencyEntry> frequencyEntries;
    @Nullable
    private final LocalDate serviceDate;

    Timetable(TimetableBuilder timetableBuilder) {
        this.pattern = timetableBuilder.getPattern();
        this.serviceDate = timetableBuilder.getServiceDate();
        this.tripTimes = timetableBuilder.createImmutableOrderedListOfTripTimes();
        this.frequencyEntries = List.copyOf(timetableBuilder.getFrequencies());
    }

    public static TimetableBuilder of() {
        return new TimetableBuilder();
    }

    public TimetableBuilder copyOf() {
        return new TimetableBuilder(this);
    }

    @Nullable
    public TripTimes getTripTimes(Trip trip) {
        for (TripTimes tt : this.tripTimes) {
            if (tt.getTrip() != trip) continue;
            return tt;
        }
        return null;
    }

    public TripTimes getTripTimes(FeedScopedId tripId) {
        for (TripTimes tt : this.tripTimes) {
            if (!tt.getTrip().getId().equals(tripId)) continue;
            return tt;
        }
        return null;
    }

    public boolean isValidFor(LocalDate serviceDate) {
        return this.serviceDate == null || this.serviceDate.equals(serviceDate);
    }

    public void setServiceCodes(Map<FeedScopedId, Integer> serviceCodes) {
        this.tripTimes = this.tripTimes.stream().map(tt -> tt.withServiceCode((Integer)serviceCodes.get(tt.getTrip().getServiceId()))).toList();
        this.frequencyEntries = this.frequencyEntries.stream().map(tt -> tt.withServiceCode((Integer)serviceCodes.get(tt.tripTimes.getTrip().getServiceId()))).toList();
    }

    public TripPattern getPattern() {
        return this.pattern;
    }

    public List<TripTimes> getTripTimes() {
        return this.tripTimes;
    }

    public List<FrequencyEntry> getFrequencyEntries() {
        return this.frequencyEntries;
    }

    @Nullable
    public LocalDate getServiceDate() {
        return this.serviceDate;
    }

    public Direction getDirection() {
        return Timetable.getDirection(this.tripTimes, this.frequencyEntries);
    }

    public TripTimes getRepresentativeTripTimes() {
        return Timetable.getRepresentativeTripTimes(this.tripTimes, this.frequencyEntries);
    }

    public boolean isCreatedByRealTimeUpdater() {
        return this.serviceDate != null;
    }

    static Direction getDirection(Collection<TripTimes> scheduledTripTimes, Collection<FrequencyEntry> frequencies) {
        return Optional.ofNullable(Timetable.getRepresentativeTripTimes(scheduledTripTimes, frequencies)).map(TripTimes::getTrip).map(Trip::getDirection).orElse(Direction.UNKNOWN);
    }

    private static TripTimes getRepresentativeTripTimes(Collection<TripTimes> scheduledTripTimes, Collection<FrequencyEntry> frequencies) {
        if (!scheduledTripTimes.isEmpty()) {
            return scheduledTripTimes.iterator().next();
        }
        if (!frequencies.isEmpty()) {
            return frequencies.iterator().next().tripTimes;
        }
        return null;
    }
}

