/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.Objects;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ValueObjectToStringBuilder;

public final class ShapePoint
implements Comparable<ShapePoint> {
    private static final double MISSING_VALUE = -999.0;
    private final int sequence;
    private final double lat;
    private final double lon;
    private final double distTraveled;

    public ShapePoint(int sequence, double lat, double lon, @Nullable Double distTraveled) {
        this.sequence = sequence;
        this.lat = DoubleUtils.requireInRange((double)lat, (double)-90.0, (double)90.0, (String)"latitude");
        this.lon = DoubleUtils.requireInRange((double)lon, (double)-180.0, (double)180.0, (String)"longitude");
        this.distTraveled = Objects.requireNonNullElse(distTraveled, -999.0);
    }

    public int sequence() {
        return this.sequence;
    }

    public boolean isDistTraveledSet() {
        return this.distTraveled != -999.0;
    }

    public double distTraveled() {
        return this.distTraveled;
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public int hashCode() {
        return Objects.hash(this.lat, this.lon, this.sequence);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapePoint that = (ShapePoint)o;
        return this.sequence == that.sequence && DoubleUtils.doubleEquals((double)this.lat, (double)that.lat) && DoubleUtils.doubleEquals((double)this.lon, (double)that.lon) && DoubleUtils.doubleEquals((double)this.distTraveled, (double)that.distTraveled);
    }

    public boolean sameCoordinates(ShapePoint that) {
        return DoubleUtils.doubleEquals((double)this.lat, (double)that.lat) && DoubleUtils.doubleEquals((double)this.lon, (double)that.lon);
    }

    public String toString() {
        ValueObjectToStringBuilder s = ValueObjectToStringBuilder.of().addNum((Number)this.sequence).addCoordinate((Number)this.lat, (Number)this.lon);
        if (this.distTraveled != -999.0) {
            s.addText(" dist=").addNum((Number)this.distTraveled);
        }
        return s.toString();
    }

    @Override
    public int compareTo(ShapePoint o) {
        return this.sequence() - o.sequence();
    }

    public Coordinate coordinate() {
        return new Coordinate(this.lon, this.lat);
    }
}

