/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class PathTransfer
implements Serializable {
    public final StopLocation from;
    public final StopLocation to;
    private final double distanceMeters;
    private final List<Edge> edges;
    private final EnumSet<StreetMode> modes;

    public PathTransfer(StopLocation from, StopLocation to, double distanceMeters, List<Edge> edges, EnumSet<StreetMode> modes) {
        this.from = from;
        this.to = to;
        this.distanceMeters = distanceMeters;
        this.edges = edges;
        this.modes = modes;
    }

    public String getName() {
        return String.valueOf(this.from) + " => " + String.valueOf(this.to);
    }

    public double getDistanceMeters() {
        return this.distanceMeters;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public EnumSet<StreetMode> getModes() {
        return EnumSet.copyOf(this.modes);
    }

    public PathTransfer withAddedMode(StreetMode mode) {
        EnumSet<StreetMode> newModes = EnumSet.copyOf(this.modes);
        newModes.add(mode);
        return new PathTransfer(this.from, this.to, this.distanceMeters, this.edges, newModes);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("from", (Object)this.from).addObj("to", (Object)this.to).addNum("distance", (Number)this.distanceMeters).addColSize("edges", this.edges).addColSize("modes", this.modes).toString();
    }
}

