/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.Objects;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.lang.StringUtils;
import org.opentripplanner.utils.tostring.ValueObjectToStringBuilder;

public class GenericLocation {
    public static final GenericLocation UNKNOWN = new GenericLocation(null, null, null, null);
    @Nullable
    public final String label;
    @Nullable
    public final FeedScopedId stopId;
    @Nullable
    public final Double lat;
    @Nullable
    public final Double lng;

    public GenericLocation(@Nullable String label, @Nullable FeedScopedId stopId, @Nullable Double lat, @Nullable Double lng) {
        this.label = label;
        this.stopId = stopId;
        this.lat = lat;
        this.lng = lng;
    }

    public static GenericLocation fromStopId(String name, String feedId, String stopId) {
        return new GenericLocation(name, new FeedScopedId(feedId, stopId), null, null);
    }

    public static GenericLocation fromCoordinate(double lat, double lng) {
        return new GenericLocation(null, null, lat, lng);
    }

    @Nullable
    public Coordinate getCoordinate() {
        if (this.lat == null || this.lng == null) {
            return null;
        }
        return new Coordinate(this.lng.doubleValue(), this.lat.doubleValue());
    }

    public boolean isSpecified() {
        return this.stopId != null || this.lat != null && this.lng != null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericLocation that = (GenericLocation)o;
        return Objects.equals(this.label, that.label) && Objects.equals(this.stopId, that.stopId) && Objects.equals(this.lat, that.lat) && Objects.equals(this.lng, that.lng);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.stopId, this.lat, this.lng);
    }

    public String toString() {
        if (UNKNOWN.equals(this)) {
            return "Unknown location";
        }
        ValueObjectToStringBuilder buf = ValueObjectToStringBuilder.of().skipNull();
        if (StringUtils.hasValue((String)this.label)) {
            buf.addText(this.label).addText(" ");
        }
        buf.addObj((Object)this.stopId);
        buf.addCoordinate((Number)this.lat, (Number)this.lng);
        return buf.toString();
    }
}

