/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.vector.vertex;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.opentripplanner.apis.support.mapping.PropertyMapper;
import org.opentripplanner.inspector.vector.KeyValue;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingEntrance;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.BarrierVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.utils.collection.ListUtils;

public class VertexPropertyMapper
extends PropertyMapper<Vertex> {
    @Override
    protected Collection<KeyValue> map(Vertex input) {
        List<KeyValue> baseProps = List.of(KeyValue.kv("elevation", this.findElevationForVertex(input)), KeyValue.kv("class", input.getClass().getSimpleName()), KeyValue.kv("label", input.getLabel().toString()));
        Vertex vertex = input;
        Objects.requireNonNull(vertex);
        Vertex vertex2 = vertex;
        int n = 0;
        List properties = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BarrierVertex.class, VehicleRentalPlaceVertex.class, VehicleParkingEntranceVertex.class}, (Object)vertex2, n)) {
            case 0 -> {
                BarrierVertex v = (BarrierVertex)vertex2;
                yield List.of(KeyValue.kv("permission", v.getBarrierPermissions().toString()));
            }
            case 1 -> {
                VehicleRentalPlaceVertex v = (VehicleRentalPlaceVertex)vertex2;
                yield List.of(KeyValue.kv("rentalId", v.getStation()));
            }
            case 2 -> {
                VehicleParkingEntranceVertex v = (VehicleParkingEntranceVertex)vertex2;
                yield List.of(KeyValue.kv("parkingId", v.getVehicleParking().getId()), KeyValue.kColl("spacesFor", this.spacesFor(v.getVehicleParking())), KeyValue.kColl("traversalPermission", this.traversalPermissions(v.getParkingEntrance())));
            }
            default -> List.of();
        };
        return ListUtils.combine((Collection[])new Collection[]{baseProps, properties, this.areaStops(input)});
    }

    private List<KeyValue> areaStops(Vertex input) {
        if (input.areaStops().isEmpty()) {
            return List.of();
        }
        return List.of(KeyValue.kv("areaStops", input.areaStops().stream().map(AbstractTransitEntity::getId).toList()));
    }

    private Set<TraverseMode> spacesFor(VehicleParking vehicleParking) {
        HashSet<TraverseMode> ret = new HashSet<TraverseMode>();
        if (vehicleParking.hasAnyCarPlaces()) {
            ret.add(TraverseMode.CAR);
        }
        if (vehicleParking.hasBicyclePlaces()) {
            ret.add(TraverseMode.BICYCLE);
        }
        return ret;
    }

    private Set<TraverseMode> traversalPermissions(VehicleParkingEntrance entrance) {
        HashSet<TraverseMode> ret = new HashSet<TraverseMode>();
        if (entrance.isCarAccessible()) {
            ret.add(TraverseMode.CAR);
        }
        if (entrance.isWalkAccessible()) {
            ret.add(TraverseMode.WALK);
        }
        return ret;
    }

    private Double findElevationForVertex(Vertex v) {
        return Stream.concat(v.getIncomingStreetEdges().stream().filter(StreetEdge::hasElevationExtension).map((? super T streetEdge) -> streetEdge.getElevationProfile().getCoordinate((int)(streetEdge.getElevationProfile().size() - 1)).y), v.getOutgoingStreetEdges().stream().filter(StreetEdge::hasElevationExtension).map((? super T streetEdge) -> streetEdge.getElevationProfile().getCoordinate((int)0).y)).findAny().orElse(null);
    }
}

