/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.vector.vertex;

import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.inspector.vector.vertex.VertexPropertyMapper;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.vertex.Vertex;

public class VertexLayerBuilder
extends LayerBuilder<Vertex> {
    private final Graph graph;

    public VertexLayerBuilder(Graph graph, LayerParameters layerParameters) {
        super(new VertexPropertyMapper(), layerParameters.name(), layerParameters.expansionFactor());
        this.graph = graph;
    }

    @Override
    protected List<Geometry> getGeometries(Envelope env) {
        return this.graph.findVertices(env).stream().map(vertex -> {
            Point geometry = GeometryUtils.getGeometryFactory().createPoint(vertex.getCoordinate());
            geometry.setUserData(vertex);
            return geometry;
        }).toList();
    }
}

