/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.vector.rental;

import java.util.Collection;
import java.util.List;
import org.opentripplanner.apis.support.mapping.PropertyMapper;
import org.opentripplanner.inspector.vector.KeyValue;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStation;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalVehicle;
import org.opentripplanner.utils.collection.ListUtils;

class RentalPropertyMapper
extends PropertyMapper<VehicleRentalPlace> {
    RentalPropertyMapper() {
    }

    @Override
    protected Collection<KeyValue> map(VehicleRentalPlace input) {
        List<KeyValue> base = List.of(KeyValue.kv("class", input.getClass().getSimpleName()), KeyValue.kv("id", input.id()), KeyValue.kv("network", input.network()), KeyValue.kv("vehiclesAvailable", input.vehiclesAvailable()), KeyValue.kv("spacesAvailable", input.spacesAvailable()));
        if (input instanceof VehicleRentalVehicle) {
            VehicleRentalVehicle vehicle = (VehicleRentalVehicle)input;
            List<KeyValue> props = List.of(KeyValue.kv("formFactor", (Object)vehicle.vehicleType().formFactor()), KeyValue.kv("isReserved", vehicle.isReserved()), KeyValue.kv("isDisabled", vehicle.isDisabled()));
            return ListUtils.combine((Collection[])new Collection[]{base, props});
        }
        if (input instanceof VehicleRentalStation) {
            VehicleRentalStation station = (VehicleRentalStation)input;
            List<KeyValue> props = List.of(KeyValue.kv("isRenting", station.isRenting()), KeyValue.kv("isReturning", station.isReturning()));
            return ListUtils.combine((Collection[])new Collection[]{base, props});
        }
        return base;
    }
}

