/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.vector.rental;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.inspector.vector.rental.RentalPropertyMapper;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;

public class RentalLayerBuilder
extends LayerBuilder<VehicleRentalPlace> {
    private final VehicleRentalService service;

    public RentalLayerBuilder(VehicleRentalService service, LayerParameters layerParameters) {
        super(new RentalPropertyMapper(), layerParameters.name(), layerParameters.expansionFactor());
        this.service = service;
    }

    @Override
    protected List<Geometry> getGeometries(Envelope env) {
        return this.service.getVehicleRentalPlacesForEnvelope(env).stream().map(place -> {
            Point geometry = GeometryUtils.getGeometryFactory().createPoint(new Coordinate(place.longitude(), place.latitude()));
            geometry.setUserData(place);
            return geometry;
        }).toList();
    }
}

