/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.vector.geofencing;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opentripplanner.apis.support.mapping.PropertyMapper;
import org.opentripplanner.inspector.vector.KeyValue;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.model.vertex.Vertex;

public class GeofencingZonesPropertyMapper
extends PropertyMapper<Vertex> {
    @Override
    protected Collection<KeyValue> map(Vertex input) {
        RentalRestrictionExtension ext = input.rentalRestrictions();
        Set<RentalRestrictionExtension.RestrictionType> debug = ext.debugTypes();
        KeyValue networks = new KeyValue("networks", String.join((CharSequence)",", ext.networks()));
        if (debug.contains((Object)RentalRestrictionExtension.RestrictionType.BUSINESS_AREA_BORDER)) {
            return List.of(new KeyValue("type", "business-area-border"), networks);
        }
        if (debug.contains((Object)RentalRestrictionExtension.RestrictionType.NO_TRAVERSAL)) {
            return List.of(new KeyValue("type", "traversal-banned"), networks);
        }
        if (debug.contains((Object)RentalRestrictionExtension.RestrictionType.NO_DROP_OFF)) {
            return List.of(new KeyValue("type", "drop-off-banned"), networks);
        }
        return List.of();
    }
}

