/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.vector.edge;

import com.google.common.collect.Lists;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.apis.support.mapping.PropertyMapper;
import org.opentripplanner.inspector.vector.KeyValue;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.EscalatorEdge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.utils.collection.ListUtils;
import org.opentripplanner.utils.lang.DoubleUtils;

public class EdgePropertyMapper
extends PropertyMapper<Edge> {
    @Override
    protected Collection<KeyValue> map(Edge input) {
        List<KeyValue> baseProps = List.of(KeyValue.kv("class", input.getClass().getSimpleName()));
        Edge edge = input;
        Objects.requireNonNull(edge);
        Edge edge2 = edge;
        int n = 0;
        List properties = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StreetEdge.class, EscalatorEdge.class}, (Object)edge2, n)) {
            case 0 -> {
                StreetEdge e = (StreetEdge)edge2;
                yield EdgePropertyMapper.mapStreetEdge(e);
            }
            case 1 -> {
                EscalatorEdge e = (EscalatorEdge)edge2;
                yield List.of(KeyValue.kv("distance", e.getDistanceMeters()), KeyValue.kv("duration", e.getDuration().map((? super T d) -> d.toString()).orElse(null)));
            }
            default -> List.of();
        };
        return ListUtils.combine((Collection[])new Collection[]{baseProps, properties});
    }

    private static List<KeyValue> mapStreetEdge(StreetEdge se) {
        ArrayList props = Lists.newArrayList((Object[])new KeyValue[]{KeyValue.kv("permission", EdgePropertyMapper.streetPermissionAsString(se.getPermission())), KeyValue.kv("bicycleSafetyFactor", DoubleUtils.roundTo2Decimals((double)se.getBicycleSafetyFactor())), KeyValue.kv("walkSafetyFactor", DoubleUtils.roundTo2Decimals((double)se.getWalkSafetyFactor())), KeyValue.kv("noThruTraffic", EdgePropertyMapper.noThruTrafficAsString(se)), KeyValue.kv("wheelchairAccessible", se.isWheelchairAccessible()), KeyValue.kv("maximumSlope", DoubleUtils.roundTo2Decimals((double)se.getMaxSlope()))});
        if (se.nameIsDerived()) {
            props.addFirst(KeyValue.kv("name", "%s (generated)".formatted(se.getName().toString())));
        } else {
            props.addFirst(KeyValue.kv("name", se.getName().toString()));
        }
        return props;
    }

    public static String streetPermissionAsString(StreetTraversalPermission permission) {
        return permission.name().replace("_AND_", " ");
    }

    private static String noThruTrafficAsString(StreetEdge se) {
        StreetTraversalPermission noThruPermission = StreetTraversalPermission.NONE;
        if (se.isWalkNoThruTraffic()) {
            noThruPermission = noThruPermission.add(StreetTraversalPermission.PEDESTRIAN);
        }
        if (se.isBicycleNoThruTraffic()) {
            noThruPermission = noThruPermission.add(StreetTraversalPermission.BICYCLE);
        }
        if (se.isMotorVehicleNoThruTraffic()) {
            noThruPermission = noThruPermission.add(StreetTraversalPermission.CAR);
        }
        return EdgePropertyMapper.streetPermissionAsString(noThruPermission);
    }
}

