/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.vector;

import edu.colorado.cires.cmg.mvt.VectorTile;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.api.resource.WebMercatorTile;
import org.opentripplanner.framework.io.HttpUtils;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

public class VectorTileResponseFactory {
    public static <LayerType extends Enum<LayerType>> Response create(int x, int y, int z, Locale locale, List<String> requestedLayers, List<LayerParameters<LayerType>> availableLayers, LayerBuilderFactory<LayerType> layerBuilderFactory, OtpServerRequestContext context) {
        VectorTile.Tile.Builder mvtBuilder = VectorTile.Tile.newBuilder();
        Envelope envelope = WebMercatorTile.tile2Envelope(x, y, z);
        int cacheMaxSeconds = Integer.MAX_VALUE;
        Set availableLayerNames = availableLayers.stream().map(LayerParameters::name).collect(Collectors.toSet());
        if (!availableLayerNames.containsAll(requestedLayers)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).header("Content-Type", HttpUtils.TEXT_PLAIN).entity((Object)"Could not find vector tile layer(s). Requested layers: %s. Available layers: %s.".formatted(requestedLayers, availableLayerNames)).build();
        }
        for (LayerParameters<LayerType> layerParameters : availableLayers) {
            if (!requestedLayers.contains(layerParameters.name()) || layerParameters.minZoom() > z || z > layerParameters.maxZoom()) continue;
            cacheMaxSeconds = Math.min(cacheMaxSeconds, layerParameters.cacheMaxSeconds());
            VectorTile.Tile.Layer layer = layerBuilderFactory.createLayerBuilder(layerParameters, locale, context).build(envelope);
            mvtBuilder.addLayers(layer);
        }
        CacheControl cacheControl = new CacheControl();
        if (cacheMaxSeconds != Integer.MAX_VALUE) {
            cacheControl.setMaxAge(cacheMaxSeconds);
        }
        return Response.status((Response.Status)Response.Status.OK).cacheControl(cacheControl).entity((Object)mvtBuilder.build().toByteArray()).build();
    }

    @FunctionalInterface
    public static interface LayerBuilderFactory<LayerType extends Enum<LayerType>> {
        public LayerBuilder<?> createLayerBuilder(LayerParameters<LayerType> var1, Locale var2, OtpServerRequestContext var3);
    }
}

