/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.gtfs.mapping.BikeAccessMapper;
import org.opentripplanner.gtfs.mapping.CarAccessMapper;
import org.opentripplanner.gtfs.mapping.DirectionMapper;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.gtfs.mapping.RouteMapper;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.gtfs.mapping.WheelchairAccessibilityMapper;
import org.opentripplanner.routing.api.request.framework.TimePenalty;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripBuilder;
import org.opentripplanner.utils.collection.MapUtils;

class TripMapper {
    private final IdFactory idFactory;
    private final RouteMapper routeMapper;
    private final DirectionMapper directionMapper;
    private final TranslationHelper translationHelper;
    private final Map<org.onebusaway.gtfs.model.Trip, Trip> mappedTrips = new HashMap<org.onebusaway.gtfs.model.Trip, Trip>();
    private final Map<Trip, TimePenalty> flexSafeTimePenalties = new HashMap<Trip, TimePenalty>();

    TripMapper(IdFactory idFactory, RouteMapper routeMapper, DirectionMapper directionMapper, TranslationHelper translationHelper) {
        this.idFactory = idFactory;
        this.routeMapper = routeMapper;
        this.directionMapper = directionMapper;
        this.translationHelper = translationHelper;
    }

    Collection<Trip> map(Collection<org.onebusaway.gtfs.model.Trip> trips) {
        return MapUtils.mapToList(trips, this::map);
    }

    Trip map(org.onebusaway.gtfs.model.Trip orginal) {
        return orginal == null ? null : this.mappedTrips.computeIfAbsent(orginal, this::doMap);
    }

    Collection<Trip> getMappedTrips() {
        return this.mappedTrips.values();
    }

    Map<Trip, TimePenalty> flexSafeTimePenalties() {
        return this.flexSafeTimePenalties;
    }

    private Trip doMap(org.onebusaway.gtfs.model.Trip rhs) {
        TripBuilder lhs = Trip.of(this.idFactory.createId(rhs.getId(), "trip"));
        lhs.withRoute(this.routeMapper.map(rhs.getRoute()));
        lhs.withServiceId(this.idFactory.createId(rhs.getServiceId(), "trip's service"));
        lhs.withShortName(rhs.getTripShortName());
        I18NString tripHeadsign = null;
        if (rhs.getTripHeadsign() != null) {
            tripHeadsign = this.translationHelper.getTranslation(org.onebusaway.gtfs.model.Trip.class, "tripHeadsign", rhs.getId().getId(), rhs.getTripHeadsign());
        }
        lhs.withHeadsign(tripHeadsign);
        lhs.withDirection(this.directionMapper.map(rhs.getDirectionId(), lhs.getId()));
        lhs.withGtfsBlockId(rhs.getBlockId());
        lhs.withShapeId(this.idFactory.createNullableId(rhs.getShapeId()));
        lhs.withWheelchairBoarding(WheelchairAccessibilityMapper.map(rhs.getWheelchairAccessible()));
        lhs.withBikesAllowed(BikeAccessMapper.mapForTrip(rhs));
        lhs.withCarsAllowed(CarAccessMapper.mapForTrip(rhs));
        Trip trip = (Trip)lhs.build();
        this.mapSafeTimePenalty(rhs).ifPresent(f -> this.flexSafeTimePenalties.put(trip, (TimePenalty)f));
        return trip;
    }

    private Optional<TimePenalty> mapSafeTimePenalty(org.onebusaway.gtfs.model.Trip rhs) {
        if (rhs.getSafeDurationFactor() == null && rhs.getSafeDurationOffset() == null) {
            return Optional.empty();
        }
        Duration offset = rhs.getSafeDurationOffset() == null ? Duration.ZERO : Duration.ofSeconds(rhs.getSafeDurationOffset().longValue());
        double factor = rhs.getSafeDurationFactor() == null ? 1.0 : rhs.getSafeDurationFactor();
        return Optional.of(TimePenalty.of(offset, factor));
    }
}

