/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Transfer;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.IgnoredGtfsTransfer;
import org.opentripplanner.graph_builder.issues.InvalidGtfsTransfer;
import org.opentripplanner.gtfs.mapping.RouteMapper;
import org.opentripplanner.gtfs.mapping.StationMapper;
import org.opentripplanner.gtfs.mapping.StaySeatedNotAllowed;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.gtfs.mapping.TransferMappingResult;
import org.opentripplanner.gtfs.mapping.TripMapper;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.RouteStationTransferPoint;
import org.opentripplanner.model.transfer.RouteStopTransferPoint;
import org.opentripplanner.model.transfer.StationTransferPoint;
import org.opentripplanner.model.transfer.StopTransferPoint;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.model.transfer.TransferPriority;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;

class TransferMapper {
    private static final int RECOMMENDED = 0;
    private static final int GUARANTEED = 1;
    private static final int MIN_TIME = 2;
    private static final int FORBIDDEN = 3;
    private static final int STAY_SEATED = 4;
    private static final int STAY_SEATED_NOT_ALLOWED = 5;
    private final RouteMapper routeMapper;
    private final StationMapper stationMapper;
    private final StopMapper stopMapper;
    private final TripMapper tripMapper;
    private final TripStopTimes stopTimesByTrip;
    private final DataImportIssueStore issueStore;
    private final Multimap<Route, Trip> tripsByRoute = ArrayListMultimap.create();
    private final boolean discardMinTransferTimes;

    TransferMapper(RouteMapper routeMapper, StationMapper stationMapper, StopMapper stopMapper, TripMapper tripMapper, TripStopTimes stopTimesByTrip, boolean discardMinTransferTimes, DataImportIssueStore issueStore) {
        this.routeMapper = routeMapper;
        this.stationMapper = stationMapper;
        this.stopMapper = stopMapper;
        this.tripMapper = tripMapper;
        this.stopTimesByTrip = stopTimesByTrip;
        this.discardMinTransferTimes = discardMinTransferTimes;
        this.issueStore = issueStore;
    }

    static TransferPriority mapTypeToPriority(int type) {
        switch (type) {
            case 3: {
                return TransferPriority.NOT_ALLOWED;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return TransferPriority.ALLOWED;
            }
            case 0: {
                return TransferPriority.RECOMMENDED;
            }
        }
        throw new IllegalArgumentException("Mapping missing for type: " + type);
    }

    TransferMappingResult map(Collection<Transfer> allTransfers) {
        this.setup(!allTransfers.isEmpty());
        List<ConstrainedTransfer> constrainedTransfers = allTransfers.stream().map(this::map).filter(Objects::nonNull).toList();
        List<StaySeatedNotAllowed> staySeatedNotAllowed = allTransfers.stream().map(this::toStaySeatedNotAllowed).filter(Objects::nonNull).toList();
        return new TransferMappingResult(constrainedTransfers, staySeatedNotAllowed);
    }

    private StaySeatedNotAllowed toStaySeatedNotAllowed(Transfer t) {
        Trip fromTrip = this.tripMapper.map(t.getFromTrip());
        Trip toTrip = this.tripMapper.map(t.getToTrip());
        if (t.getTransferType() == 5) {
            return new StaySeatedNotAllowed(fromTrip, toTrip);
        }
        return null;
    }

    ConstrainedTransfer map(Transfer rhs) {
        Trip fromTrip = this.tripMapper.map(rhs.getFromTrip());
        Trip toTrip = this.tripMapper.map(rhs.getToTrip());
        TransferConstraint constraint = this.mapConstraint(rhs);
        if (constraint.isRegularTransfer()) {
            this.issueStore.add(new IgnoredGtfsTransfer(rhs));
            return null;
        }
        if (constraint.isStaySeated() && (fromTrip == null || toTrip == null)) {
            this.issueStore.add(new InvalidGtfsTransfer("from_trip_id and to_trip_id must exist for in-seat transfer", rhs));
            return null;
        }
        TransferPoint fromPoint = this.mapTransferPoint(rhs.getFromStop(), rhs.getFromRoute(), fromTrip, false);
        TransferPoint toPoint = this.mapTransferPoint(rhs.getToStop(), rhs.getToRoute(), toTrip, true);
        if (fromPoint == null || toPoint == null) {
            this.issueStore.add(new InvalidGtfsTransfer("fromPoint / toPoint doesn't exist", rhs));
            return null;
        }
        return new ConstrainedTransfer(null, fromPoint, toPoint, constraint);
    }

    private void setup(boolean run) {
        if (!run) {
            return;
        }
        for (Trip trip : this.tripMapper.getMappedTrips()) {
            this.tripsByRoute.put((Object)trip.getRoute(), (Object)trip);
        }
    }

    private TransferConstraint mapConstraint(Transfer rhs) {
        TransferConstraint.Builder builder = TransferConstraint.of();
        builder.guaranteed(rhs.getTransferType() == 1);
        builder.staySeated(rhs.getTransferType() == 4);
        builder.priority(TransferMapper.mapTypeToPriority(rhs.getTransferType()));
        if (!this.discardMinTransferTimes && rhs.isMinTransferTimeSet()) {
            builder.minTransferTime(rhs.getMinTransferTime());
        }
        return builder.build();
    }

    private TransferPoint mapTransferPoint(Stop rhsStopOrStation, org.onebusaway.gtfs.model.Route rhsRoute, Trip trip, boolean boardTrip) {
        Route route = this.routeMapper.map(rhsRoute);
        Station station = null;
        RegularStop stop = null;
        if (rhsStopOrStation.getLocationType() == 0) {
            stop = this.stopMapper.map(rhsStopOrStation);
        } else {
            station = this.stationMapper.map(rhsStopOrStation);
        }
        if (trip != null) {
            int stopPositionInPattern = boardTrip ? this.boardStopPosition(trip, stop, station) : this.alightStopPosition(trip, stop, station);
            return stopPositionInPattern < 0 ? null : new TripTransferPoint(trip, stopPositionInPattern);
        }
        if (route != null) {
            if (stop != null) {
                return new RouteStopTransferPoint(route, stop);
            }
            if (station != null) {
                return new RouteStationTransferPoint(route, station);
            }
        } else {
            if (stop != null) {
                return new StopTransferPoint(stop);
            }
            if (station != null) {
                return new StationTransferPoint(station);
            }
        }
        throw new IllegalStateException("Should not get here!");
    }

    private int boardStopPosition(Trip trip, RegularStop stop, Station station) {
        List<StopTime> stopTimes = this.stopTimesByTrip.get(trip);
        Predicate<StopLocation> stopMatches = station != null ? s -> {
            RegularStop regStop;
            return s instanceof RegularStop && (regStop = (RegularStop)s).getParentStation() == station;
        } : s -> s == stop;
        for (int i = 0; i < stopTimes.size() - 1; ++i) {
            StopTime stopTime = stopTimes.get(i);
            if (stopTime.getPickupType().isNotRoutable() || !stopMatches.test(stopTime.getStop())) continue;
            return i;
        }
        return -1;
    }

    private int alightStopPosition(Trip trip, RegularStop stop, Station station) {
        List<StopTime> stopTimes = this.stopTimesByTrip.get(trip);
        Predicate<StopLocation> stopMatches = station != null ? s -> {
            RegularStop regStop;
            return s instanceof RegularStop && (regStop = (RegularStop)s).getParentStation() == station;
        } : s -> s == stop;
        for (int i = stopTimes.size() - 1; i > 0; --i) {
            StopTime stopTime = stopTimes.get(i);
            if (stopTime.getDropOffType().isNotRoutable() || !stopMatches.test(stopTime.getStop())) continue;
            return i;
        }
        return -1;
    }
}

