/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.onebusaway.gtfs.model.StopAreaElement;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.transit.model.framework.FeedScopedId;

class StopAreaMapper {
    private final IdFactory idFactory;

    StopAreaMapper(IdFactory idFactory) {
        this.idFactory = idFactory;
    }

    public Multimap<FeedScopedId, FeedScopedId> map(Collection<StopAreaElement> entries) {
        ArrayListMultimap res = ArrayListMultimap.create();
        entries.forEach(e -> {
            FeedScopedId stopId = this.idFactory.createId(e.getStop().getId(), "stop area assignment");
            FeedScopedId areaId = this.idFactory.createId(e.getArea().getId(), "stop area assignment");
            res.put((Object)stopId, (Object)areaId);
        });
        return res;
    }
}

