/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.ShapePoint;
import org.opentripplanner.gtfs.mapping.CompactShape;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.transit.model.framework.FeedScopedId;

class ShapePointMapper {
    private final IdFactory idFactory;

    ShapePointMapper(IdFactory idFactory) {
        this.idFactory = idFactory;
    }

    Map<FeedScopedId, CompactShape> map(Collection<ShapePoint> allShapePoints) {
        HashMap<FeedScopedId, CompactShape> ret = new HashMap<FeedScopedId, CompactShape>();
        for (ShapePoint shapePoint : allShapePoints) {
            FeedScopedId shapeId = this.idFactory.createId(shapePoint.getShapeId(), "shape point");
            CompactShape shape = ret.computeIfAbsent(shapeId, id -> new CompactShape());
            shape.addPoint(shapePoint);
        }
        return ret;
    }
}

