/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.gtfs.mapping.StopMappingWrapper;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.PathwayNode;
import org.opentripplanner.transit.model.site.PathwayNodeBuilder;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.utils.collection.MapUtils;

class PathwayNodeMapper {
    static final String DEFAULT_NAME = "Pathway node";
    private final IdFactory idFactory;
    private final Map<Stop, PathwayNode> mappedNodes = new HashMap<Stop, PathwayNode>();
    private final TranslationHelper translationHelper;
    private final Function<FeedScopedId, Station> stationLookUp;

    PathwayNodeMapper(IdFactory idFactory, TranslationHelper translationHelper, Function<FeedScopedId, Station> stationLookUp) {
        this.idFactory = idFactory;
        this.translationHelper = translationHelper;
        this.stationLookUp = stationLookUp;
    }

    Collection<PathwayNode> map(Collection<Stop> allNodes) {
        return MapUtils.mapToList(allNodes, this::map);
    }

    PathwayNode map(Stop orginal) {
        return orginal == null ? null : this.mappedNodes.computeIfAbsent(orginal, this::doMap);
    }

    private PathwayNode doMap(Stop gtfsStop) {
        if (gtfsStop.getLocationType() != 3) {
            throw new IllegalArgumentException("Expected type 3, but got " + gtfsStop.getLocationType());
        }
        StopMappingWrapper base = new StopMappingWrapper(this.idFactory, gtfsStop);
        PathwayNodeBuilder builder = (PathwayNodeBuilder)((PathwayNodeBuilder)((PathwayNodeBuilder)((PathwayNodeBuilder)PathwayNode.of(base.getId()).withCode(base.getCode())).withCoordinate(base.getCoordinate())).withWheelchairAccessibility(base.getWheelchairAccessibility())).withLevel(base.getLevel());
        builder.withName(this.translationHelper.getTranslation(Stop.class, "name", base.getId().getId(), Optional.ofNullable(base.getName()).orElse(DEFAULT_NAME)));
        builder = (PathwayNodeBuilder)builder.withDescription(this.translationHelper.getTranslation(Stop.class, "desc", base.getId().getId(), base.getDescription()));
        if (gtfsStop.getParentStation() != null) {
            builder.withParentStation(this.stationLookUp.apply(base.getParentStationId()));
        }
        return (PathwayNode)builder.build();
    }
}

