/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.LocalizedString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.gtfs.mapping.LocationMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.GroupStopBuilder;
import org.opentripplanner.transit.service.SiteRepositoryBuilder;
import org.opentripplanner.utils.collection.MapUtils;

class LocationGroupMapper {
    private static final LocalizedString FALLBACK_NAME = new LocalizedString("locationGroup");
    private final IdFactory idFactory;
    private final StopMapper stopMapper;
    private final LocationMapper locationMapper;
    private final SiteRepositoryBuilder siteRepositoryBuilder;
    private final Map<LocationGroup, GroupStop> mappedLocationGroups = new HashMap<LocationGroup, GroupStop>();

    public LocationGroupMapper(IdFactory idFactory, StopMapper stopMapper, LocationMapper locationMapper, SiteRepositoryBuilder siteRepositoryBuilder) {
        this.idFactory = idFactory;
        this.stopMapper = stopMapper;
        this.locationMapper = locationMapper;
        this.siteRepositoryBuilder = siteRepositoryBuilder;
    }

    Collection<GroupStop> map(Collection<LocationGroup> allLocationGroups) {
        return MapUtils.mapToList(allLocationGroups, this::map);
    }

    GroupStop map(@Nullable LocationGroup original) {
        return original == null ? null : this.mappedLocationGroups.computeIfAbsent(original, this::doMap);
    }

    private GroupStop doMap(LocationGroup element) {
        FeedScopedId id = this.idFactory.createId(element.getId(), "location group");
        I18NString name = NonLocalizedString.ofNullableOrElse(element.getName(), FALLBACK_NAME);
        GroupStopBuilder groupStopBuilder = this.siteRepositoryBuilder.groupStop(id).withName(name);
        block5: for (StopLocation location : element.getLocations()) {
            StopLocation stopLocation;
            Objects.requireNonNull(location, "Location group '%s' contains a null element.".formatted(element.getId()));
            Objects.requireNonNull(location);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Stop.class, Location.class, LocationGroup.class}, (Object)stopLocation, n)) {
                case 0: {
                    Stop stop = (Stop)stopLocation;
                    groupStopBuilder.addLocation(this.stopMapper.map(stop));
                    continue block5;
                }
                case 1: {
                    Location loc = (Location)stopLocation;
                    groupStopBuilder.addLocation(this.locationMapper.map(loc));
                    continue block5;
                }
                case 2: {
                    LocationGroup ignored = (LocationGroup)stopLocation;
                    throw new RuntimeException("Nested GroupStops are not allowed");
                }
            }
            throw new RuntimeException("Unknown location type: " + location.getClass().getSimpleName());
        }
        return (GroupStop)groupStopBuilder.build();
    }
}

