/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Objects;
import javax.annotation.Nullable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.lang.StringUtils;

class IdFactory {
    private final String feedId;

    IdFactory(String feedId) {
        this.feedId = Objects.requireNonNull(feedId);
    }

    FeedScopedId createId(AgencyAndId id, String entityName) {
        Objects.requireNonNull(id, IdFactory.idErrorMessage(entityName));
        return this.createId(id.getId(), entityName);
    }

    FeedScopedId createId(String id, String entityName) {
        if (StringUtils.hasNoValue((String)id)) {
            throw new IllegalArgumentException(IdFactory.idErrorMessage(entityName));
        }
        return new FeedScopedId(this.feedId, id);
    }

    @Nullable
    FeedScopedId createNullableId(@Nullable AgencyAndId id) {
        return id == null ? null : new FeedScopedId(this.feedId, id.getId());
    }

    @Nullable
    FeedScopedId createNullableId(@Nullable String id) {
        return id == null ? null : new FeedScopedId(this.feedId, id);
    }

    private static String idErrorMessage(String entityName) {
        return "Error during GTFS processing: id of %s is null or consists of whitespace only".formatted(entityName);
    }
}

